import React, { useMemo } from 'react';
import { Button, Tooltip } from 'antd';

const FC = (props) => {
  const { permissionKey, permissions, defaultPermission, disabled, tip, ...restProps } = props;

  const havePermission = useMemo(() => {
    let _havePermission = true;

    if (defaultPermission===false) {
      _havePermission = defaultPermission;
    } else if (permissionKey) {
      const index = (permissions||[]).findIndex(item => item === permissionKey);
      _havePermission = (index !== -1);
    }
    
    return _havePermission;
  }, [permissionKey, permissions, defaultPermission])

  return (
    <Tooltip title={havePermission?tip:'暂无权限'}>
      <Button disabled={!havePermission||disabled} {...restProps} />
    </Tooltip>
  )
}

export default FC;