import { GetJSON, PostJSON, callFetchRaw, PostFile } from "../util/axios"

export function queryDatabase(payload) {
  return GetJSON("/metadatarepo/rest/tag/getDatabaseBySystemCode", payload);
}

export function querySchemeByParentId(payload) {
  return GetJSON("/metadatarepo/rest/metadata/getChild", payload);
}

export function queryAllDataTable(payload) {
  return GetJSON("/metadatarepo/rest/tag/pageTree", payload);
}

export function queryAllFields(payload) {
  return GetJSON("/metadatarepo/rest/metadata/getChild", payload);
}

export function getSystemAllGraph(payload) {
  return GetJSON("/metadatarelation/getSystemAllGraph", payload);
}

export function getAttributes(payload) {
  return PostJSON("/metadatarepo/rest/metadata/getByIdList", payload);
}

export function exportAttributes(payload) {
  return callFetchRaw('post', '/metadatarepo/rest/download/exportAssetInfo', payload)
}

export function importAttributes(payload) {
  return PostFile("/metadatarepo/rest/import/importAssetInf", payload);
}

export function listImportAssetLog(payload) {
  return GetJSON('/metadatarepo/rest/import/listImportAssertLog', payload);
}

export function getImportAssetLogDetail(payload) {
  return GetJSON('/metadatarepo/rest/import/getImportAssertLog', payload);
}