import { PostJSON, GetJSON, Delete } from "../util/axios"

export function getScopes() {
  return GetJSON("/authservice/personal/joinedScopes");
}

export function getAllSupportedDatasourceTypies() {
  return GetJSON("/metadataharvester/datasource/getAllSupportedDatasourceTypies");
}

export function getSupportedTargetTypes() {
  return GetJSON("/metadataharvester/datasource/getSupportedTargetTypes");
}

export function getAllDatasources(payload) {
  return GetJSON("/metadataharvester/datasource/getAllDatasources", payload);
}

export function saveDatasource(payload) {
  return PostJSON("/metadataharvester/datasource/saveDatasource", payload);
}

export function validateDatasource(payload) {
  return PostJSON("/metadataharvester/datasource/validateDatasource", payload);
}

export function getDatasource(payload) {
  return GetJSON("/metadataharvester/datasource/getDatasource", payload);
}

export function deleteDatasource(payload) {
  return Delete("/metadataharvester/datasource/deleteDatasource", payload);
}

export function getTaskSettingsByDatasource(payload) {
  return GetJSON("/metadataharvester/task/getHarvestingTaskSettings", payload);
}

export function getTasksByDatasourceId(payload) {
  return GetJSON("/metadataharvester/task/findHarvestingTasks", payload);
}

export function saveTask(payload) {
  return PostJSON("/metadataharvester/task/saveHarvestingTask", payload);
}

export function getTask(payload) {
  return GetJSON("/metadataharvester/task/getHarvestingTask", payload);
}

export function deleteTask(payload) {
  return Delete("/metadataharvester/task/deleteHarvestingTask", payload);
}

export function startTask(payload) {
  return PostJSON("/metadataharvester/task/startHarvestingTask", payload);
}

export function getTaskReportSummary(payload) {
  return GetJSON("/metadataharvester/task/getTaskReportSummary", payload);
}

export function getTaskReportDetail(payload) {
  return GetJSON("/metadataharvester/task/getTaskReportDetail", payload);
}

export function getTaskStates(payload) {
  return GetJSON("/metadataharvester/task/getTaskStates", payload);
}

export function getTaskTracerByStateId(payload) {
  return GetJSON("/metadataharvester/task/getTaskTracerByStateId", payload);
}

export function deleteSchedule(payload) {
  return Delete("/metadataharvester/schedule/deleteSchedule", payload);
}

export function getScheduleForm(payload) {
  return GetJSON("/metadataharvester/schedule/getScheduleForm", payload);
}

export function getScheduleById(payload) {
  return GetJSON("/metadataharvester/schedule/getTaskById", payload);
}

export function getScheduleListByTaskId(payload) {
  return PostJSON("/metadataharvester/schedule/getTaskListByTargetConfId", payload);
}

export function saveAndStartSchedule(payload) {
  return PostJSON("/metadataharvester/schedule/saveAndStartSchedule", payload);
}

export function getAllTaskProgress() {
  return GetJSON("/metadataharvester/redis/getAllTaskProgress");
}

