import { PostFile, GetJSON, PostJSON, Post, Get, Delete, callFetchRaw } from "../util/axios"

export function loadDataModelCatalog() {
  return GetJSON("/datamodeler/easyDataModelerCURD/loadDataModelCatalog");
}

export function refreshDataModelCatalog() {
  return GetJSON("/datamodeler/easyDataModelerCURD/refreshDataModelCatalog");
}

export function loadDataModelStateCatalog() {
  return GetJSON("/datamodeler/easyDataModelerCURD/loadDataModelStateCatalog");
}

export function saveDataModelCatalog(payload) {
  return Post("/datamodeler/easyDataModelerCURD/saveDataModelCatalog", payload);
} 

export function deleteDataModelCatalog(payload) {
  return PostJSON("/datamodeler/easyDataModelerCURD/deleteDataModelCatalog", payload);
}

export function upDownModelCatalog(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/upDownModelCatalog", payload);
}

//绑定模型和模型目录
export function bindCatalogDataModel(payload) {
  return Post("/datamodeler/easyDataModelerCURD/catalogDataModel", payload);
}

//读取当前模型目录中的模型
export function getCurrentDataModelCatalog(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/getCurrentDataModelCatalog", payload);
}

//读取当前模型目录中的模型(状态)
export function getCurrentDataModelStateCatalog(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/getCurrentDataModelStateCatalog", payload);
}

export function nextState(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/nextState", payload);
}

export function recatalogDataModel(payload) {
  return Post("/datamodeler/easyDataModelerCURD/recatalogDataModel", payload);
}

export function modelCopy(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/copy", payload);
}

export function getSupportedPartitionTypes(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/getSupportedPartitionTypes", payload);
}

export function savePartitionType(payload) {
  return PostJSON("/datamodeler/easyDataModelerCURD/savePartitionType", payload);
}

export function deletePartitionType(payload) {
  return PostJSON("/datamodeler/easyDataModelerCURD/deletePartitionType", payload);
}

export function getSupportedIndextypes() {
  return GetJSON("/datamodeler/easyDataModelerCURD/getSupportedIndextypes");
}

export function extractExcelContent(payload) {
  return PostFile("/datamodeler/easyDataModelerDesign/kickStart", payload);
}

//规则
export function constraints() {
  return GetJSON("/datamodeler/easyDataModelerConstraint/constraints");
}

//模版
export function templates() {
  return GetJSON("/datamodeler/easyDataModelerTemplateCURD/getAllDataModelTemplates");
}

export function getTemplate(payload) {
  return PostJSON("/datamodeler/easyDataModelerTemplateCURD/getDataModelTemplate", payload);
}

export function saveTemplate(payload) {
  return PostJSON("/datamodeler/easyDataModelerTemplateCURD/saveDataModelTemplate", payload);
}

export function deleteTemplate(payload) {
  return PostJSON("/datamodeler/easyDataModelerTemplateCURD/deleteDataModelTemplate", payload);
}

//创建初稿
export function draft(payload) {
  return PostJSON("/datamodeler/easyDataModelerDesign/draft", payload);
}

export function draftUsingDDL(payload) {
  return PostJSON("/datamodeler/easyDataModelerDesign/draftUsingDDL", payload);
}

export function draftUsingMetadataId(payload) {
  return PostJSON("/datamodeler/easyDataModelerDesign/draftUsingMetadataTableId", payload);
}

//切换模版或者规范时调用
export function consult(payload) {
  return PostJSON("/datamodeler/easyDataModelerDesign/consult", payload);
}

export function translatePhase(payload) {
  return PostJSON("/datamodeler/easyDataModelerDesign/translatePhase", payload);
}

//获取支持的数据类型
export function getSupportedDatatypes() {
  return GetJSON("/datamodeler/easyDataModelerCURD/getSupportedDatatypes");
}

export function suggest(payload) {
  return PostJSON("/datamodeler/easyDataModelerDesign/suggest", payload);
}

export function preSaveDataModel(payload) {
  return PostJSON("/datamodeler/easyDataModelerCURD/preSaveDataModel", payload);
}

//保存模型
export function saveDataModel(payload) {
  return PostJSON("/datamodeler/easyDataModelerCURD/saveDataModel", payload);
}

export function deleteDataModel(payload) {
  return PostJSON("/datamodeler/easyDataModelerCURD/deleteDataModel", payload);
}

export function deleteDataModels(payload) {
  return Post("/datamodeler/easyDataModelerCURD/deleteDataModels", payload);
}

export function getDataModel(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/getDataModel", payload);
}

export function getDataModelWithRecommendedDefinitionAndTermDiscovery(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/getDataModelWithRecommendedDefinitionAndTermDiscovery", payload);
}

export function checkOutDataModel(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/checkOutDataModel", payload);
}

export function getDataModelLocation(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/getDataModelLocation", payload);
}

export function searchModel(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/searchEasyDataModelerDataModelsByNaming", payload);
}

export function getVersions(payload) {
  return PostJSON("/datamodeler/easyDataModelerCURD/getVersions", payload);
}

export function compare(payload) {
  return PostJSON("/datamodeler/easyDataModelerCURD/compareVersion", payload);
}

export function getDataModelByVersionId(payload) {
  return PostJSON("/datamodeler/easyDataModelerCURD/getDataModelByVersionId", payload);
}

export function getDataModelDigest(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/getDataModelDigest", payload);
}

export function isSetRootDomainId() {
  return Get("/datamodeler/easyDataModelerCURD/isSetRootDomainId");
}

export function setRootDomainId(payload) {
  return PostJSON("/datamodeler/easyDataModelerCURD/setRootDomainId", payload);
}

export function getMaintenanceRecords(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/getMaintenanceRecords", payload);
}

export function getCheckoutDataModel(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/getCheckoutDataModel", payload);
}

export function getRangeList(payload) {
  return GetJSON("/datamodeler/easyDataModelerCURD/getRangeList", payload);
}

export function ddlGenerators() {
  return GetJSON("/datamodeler/easyDataModelerExport/ddlGenerators");
}

export function exportDDLString(payload) {
  return GetJSON("/datamodeler/easyDataModelerExport/ddlString", payload);
}

export function exportERWinString(payload) {
  return GetJSON("/datamodeler/easyDataModelerExport/erWinPluginString", payload);
}

export function uploadWordTemplate(payload) {
  return PostFile("/datamodeler/easyDataModelerExport/word/uploadTemplate", payload);
}

export function importWordGenerateModel(payload) {
  return PostFile("/datamodeler/easyDataModelerExport/word", payload);
}

export function importWordLogs(payload) {
  return PostJSON("/datamodeler/easyDataModelerExport/log/list", payload);
}

export function importWordGenerateModelDraft(payload) {
  return PostFile("/datamodeler/easyDataModelerExport/word/draft", payload);
}

export function uploadDDL(payload) {
  return PostJSON("/datamodeler/easyDataModelerExport/uploadDDL", payload);
}

export function heartbeat() {
  return Get("/datamodeler/easyDataModelerExport/heartbeat");
}

export function downloadExportTableDDLListZip(payload) {
  return callFetchRaw("post","/datamodeler/easyDataModelerExport/downloadExportTableDDLListZip", payload);
}

export function exportTableDDLAbstractList(payload) {
  return PostJSON("/datamodeler/easyDataModelerExport/exportTableDDLAbstractList", payload);
}

export function getExportTableDDL(payload) {
  return Post("/datamodeler/easyDataModelerExport/getExportTableDDL", payload);
}

export function getPreviewTableDDL(payload) {
  return Post("/datamodeler/easyDataModelerExport/getPreviewTableDDL", payload)
}

export function validateDataModel(payload) {
  return PostJSON("/datamodeler/easyDataModelerConstraint/validateDataModel", payload);
}

export function autocomplete(payload) {
  return PostJSON("/datamodeler/easyDataModelerDesign/autocomplete", payload);
}

export function recommandEnglishWords(payload) {
  return PostJSON("/datamodeler/easyDataModelerDesign/recommandEnglishWords", payload);
}

export function startFlow(payload) {
  return PostJSON("/datamodeler/easyDataModelerWorkflowSupport/addPhysicalModelApproval", payload);
}

export function getDatasourcesByEnv (payload) {
  return GetJSON("/metadatarepo/rest/metadata/findByModelAndSys", payload);
}

export function getSchemasByDatasourceId(payload) {
  return GetJSON("/metadatarepo/rest/query/getChild", payload);
}

export function getParent(payload) {
  return GetJSON("/metadatarepo/rest/query/getParent", payload);
}

export function autoCreateTable(payload) {
  return PostJSON("/metadataharvester/datasource/createTableByDDLList", payload);
}

export function requirementList(payload) {
  return GetJSON("/datarequirement/dataReqTechJobAssoc/requirementList", payload);
}

export function getBindingDataList(payload) {
  return GetJSON("/datarequirement/dataReqTechJobAssoc/getBindingDataList", payload);
}

export function requirementBind(payload) {
  return PostJSON("/datarequirement/dataReqTechJobAssoc/binding", payload);
}

export function requirementUnbind(payload) {
  return PostJSON("/datarequirement/dataReqTechJobAssoc/unbinding", payload);
}

export function getRuleTemplateList() {
  return GetJSON("/datamodeler/easyDataModelerRuleTemplate/list");
}

/* rule template */
export function addRuleTemplate(payload) {
  return PostJSON("/datamodeler/easyDataModelerRuleTemplate/add", payload);
}

export function updateRuleTemplate(payload) {
  return PostJSON("/datamodeler/easyDataModelerRuleTemplate/update", payload);
}

export function deletesRuleTemplate(payload) {
  return Delete("/datamodeler/easyDataModelerRuleTemplate/dels", payload);
}

export function deleteRuleTemplate(payload) {
  return Delete("/datamodeler/easyDataModelerRuleTemplate/del", payload);
}

export function getRuleTemplateDetail(payload) {
  return GetJSON("/datamodeler/easyDataModelerRuleTemplate/getById", payload);
}

export function getRuleTemplateCheckTypes() {
  return GetJSON("/datamodeler/easyDataModelerRuleTemplate/getCheckTypes");
}

export function getRuleTemplateAllCheckPropertyTypes() {
  return GetJSON("/datamodeler/easyDataModelerRuleTemplate/getAllCheckPropertyTypes");
}

export function getRuleTemplateAllVerifyExpressionTypes() {
  return GetJSON("/datamodeler/easyDataModelerRuleTemplate/getAllVerifyExpressionTypes")
}

export function getRuleTemplateAllVertifyExpressions() {
  return GetJSON("/datamodeler/easyDataModelerRuleTemplate/getAllVerifyExpressions")
}

/* rule catalog  */
export function addRuleCatalog(payload) {
  return PostJSON("/datamodeler/easyDataModelerRuleCatalog/add", payload)
}

export function updateRuleCatalog(payload) {
  return PostJSON("/datamodeler/easyDataModelerRuleCatalog/update", payload)
}

export function upRuleCatalog(payload) {
  return PostJSON("/datamodeler/easyDataModelerRuleCatalog/up", payload)
}

export function downRuleCatalog(payload) {
  return PostJSON("/datamodeler/easyDataModelerRuleCatalog/down", payload)
}

export function deleteRuleCatalog(payload) {
  return Delete("/datamodeler/easyDataModelerRuleCatalog/del", payload)
}

export function getRuleCatalogList() {
  return GetJSON("/datamodeler/easyDataModelerRuleCatalog/list")
}

export function getRuleCatalogEnableList() {
  return GetJSON("/datamodeler/easyDataModelerRuleCatalog/enableList")
}

export function getRuleCatalogVersionList(payload) {
  return GetJSON("/datamodeler/easyDataModelerRuleCatalog/versionList", payload)
}

export function compareRuleCatalogVersion(payload) {
  return GetJSON("/datamodeler/easyDataModelerRuleCatalog/compare", payload)
}

export function getRuleCatalogStatus() {
  return GetJSON("/datamodeler/easyDataModelerRuleCatalog/getRuleStatus")
}

/* rule */
export function addRule(payload) {
  return PostJSON("/datamodeler/easyDataModelerRule/add", payload)
}

export function updateRule(payload) {
  return PostJSON("/datamodeler/easyDataModelerRule/update", payload)
}

export function deleteRules(payload) {
  return Delete("/datamodeler/easyDataModelerRule/dels", payload)
}

export function getRuleList(payload) {
  return GetJSON("/datamodeler/easyDataModelerRule/getListByCatalogId", payload)
}

export function getRuleAlertTypes() {
  return GetJSON("/datamodeler/easyDataModelerRule/getRuleAlertTypes")
}

export function getRuleStatus() {
  return GetJSON("/datamodeler/easyDataModelerRule/getRuleStatus")
}

export function addComment(payload) {
  return PostJSON("/datamodelercomment/comment/add", payload)
}

export function deleteComment(payload) {
  return Delete("/datamodelercomment/comment/del", payload)
}

export function getComments(payload) {
  return GetJSON("/datamodelercomment/comment/list", payload)
}

export function uploadCommentFile(payload) {
  return PostFile("/datamodelercomment/file/upload", payload)
}

export function deleteCommentFile(payload) {
  return Delete("/datamodelercomment/file/del", payload) 
}

export function getSearchProperties() {
  return GetJSON("/datamodeler/easyDataModelerCURD/getModelSearchProperties")
}

export function searchModelBySearchProperties(payload) {
  return PostJSON("/datamodeler/easyDataModelerCURD/searchEasyDataModelerDataModelsByModelSearchProperties", payload);
}

//zcx hive
export function getDbTypes() {
  return GetJSON("/datamodeler/easyDataModelerCURD/getDbTypes")
}

//zcx hive
export function getHiveStoredTypes() {
  return GetJSON("/datamodeler/easyDataModelerCURD/getHiveStoredTypes")
}

export function conceptualModelCreateDataModel(payload) {
  return PostJSON("/datamodeler/easyDataModelerConceptualModeling/populdateDataModel", payload)
}

export function getUploadDDLResultDetails(payload) {
  return GetJSON("/datamodeler/easyDataModelerUploadDDLResult/getUploadDDLResultDetails", payload)
}