import { PostJSON, GetJSON, PostFile, Post, Get, callFetchRaw } from "../util/axios"
import qs from "qs";

export function listDataAssets(payload) {
  
}
export function importElement(payload) {
  return PostFile("/dataassetmanager/elementApi/import", payload);
}

export function getLogs(payload) {
  return GetJSON("/dataassetmanager/elementApi/listOperationLogsByPage", payload);
}

export function listElements(payload) {
  return PostJSON("/dataassetmanager/elementApi/listElements",payload);
}

export function listElementsAndFillValue(payload) {
  return PostJSON("/dataassetmanager/elementApi/listElementAndFillValueByDirId", payload)
}

export function listUserElements() {
  return PostJSON("/dataassetmanager/elementApi/listSelectedRangeElements");
}

export function listCustomElements() {
  return GetJSON("/dataassetmanager/elementApi/listCustomElements");
}

export function listFilterElementIds(payload) {
  return GetJSON("/dataassetmanager/elementApi/listFilterElementIds", payload);
}

export function listFilterElements() {
  return GetJSON("/dataassetmanager/elementApi/listFilterElements");
}

export function listFilterElementsGroupByType(payload) {
  return GetJSON("/dataassetmanager/elementApi/listFilterElementsGroupByType", payload);
}

export function setupFilterElementIds(payload) {
  return PostJSON("/dataassetmanager/elementApi/setupFilterElementIds", payload);
}

export function listFilterElementIdsConfig() {
  return PostJSON("/dataassetmanager/configApi/listFilterElementIds");
}

export function setupFilterElementIdsConfig(payload) {
  return PostJSON("/dataassetmanager/configApi/setupFilterElementIds", payload);
}

export function addOrUpdateDataAsset(payload) {
  return PostJSON("/dataassetmanager/dataAssetApi/addOrUpdateDataAsset", payload);
}

export function checkCodeIsExist(payload) {
  return Post("/dataassetmanager/dataAssetApi/checkDataAssetCodeIsExist", payload);
}

export function checkDataAssetEditable(payload) {
  return Post("/dataassetmanager/dataAssetApi/checkDataAssetEditable", payload);
}

export function addDataAssetByDirIds(payload) {
  return PostJSON("/dataassetmanager/dataAssetApi/addDataAssetByDirIds", payload);
}

export function deleteDataAssets(payload) {
  return PostJSON("/dataassetmanager/dataAssetApi/deleteDataAssets", payload);
}

export function getDataAssetDetail(payload) {
  return GetJSON("/dataassetmanager/dataAssetApi/getDataAssetDetail", payload);
}

export function listDataAssetsByPage(payload) {
  return GetJSON("/dataassetmanager/dataAssetApi/listDataAssetsByPage", payload);
}

export function listDataAssetsByPersonalCustomType(payload) {
  return GetJSON("/dataassetmanager/dataAssetApi/listDataAssetsByPersonalCustomType", payload);
}

export function listRecycleBinDataAssetsByPage(payload) {
  return GetJSON("/dataassetmanager/dataAssetApi/listRecycleBinDataAssetsByPage", payload);
}

export function loadDataAssets(payload) {
  return PostJSON("/dataassetmanager/dataAssetApi/loadDataAssets", payload);
}

export function unloadDataAssets(payload) {
  return PostJSON("/dataassetmanager/dataAssetApi/unloadDataAssetsByDataAssetIdAndDirId", payload);
}

export function unloadDataAssetsFromAllDirs(payload) {
  return PostJSON("/dataassetmanager/dataAssetApi/unloadDataAssetsFromAllDirs", payload);
}

export function getDataAssetLocation(payload) {
  return GetJSON("/dataassetmanager/dataAssetApi/locateDataAssetById", payload);
}

export function createDataAssetByMetadataIds(payload) {
  return PostJSON("/dataassetmanager/dataAssetApi/createDataAssetByMetadataIds", payload);
}

export function importLogs(payload) {
  return GetJSON("/dataassetmanager/dataAssetApi/listDataAssetImportLogsByPage", payload);
}

// 导入草稿日志 /draftApi/listDraftImportLogsByPage
export function importDraftLogs(payload) {
  return GetJSON("/dataassetmanager/draftApi/listDraftImportLogsByPage", payload);
}


export function recoveryFromRecycleBin(payload) {
  return PostJSON("/dataassetmanager/dataAssetApi/recoveryFromRecycleBin", payload);
}

export function getAssetPaths(payload) {
  return GetJSON("/dataassetmanager/dataAssetApi/getMultiPath", payload);
}

export function addOrUpdateDirectory(payload) {
  return PostJSON("/dataassetmanager/directoryApi/addOrUpdateDirectory", payload);
}

export function checkDirectoryDeleteAble(payload) {
  return Post("/dataassetmanager/directoryApi/checkDirDeleteAble", payload);
}

export function deleteDirectory(payload) {
  return PostJSON("/dataassetmanager/directoryApi/deleteDirectory", payload);
}

export function deletePersonalCustomDirectory(payload) {
  return PostJSON("/dataassetmanager/directoryApi/deletePersonalCustomDirectory", payload);
}

export function existDataAsset(payload) {
  return GetJSON("/dataassetmanager/directoryApi/existDataAsset", payload);
}

export function queryAllDirectoryAsTree(payload) {
  return GetJSON("/dataassetmanager/directoryApi/queryAllDirectoryAsTree", payload);
}

export function queryDirectoryTreeByMetadataId(payload) {
  return GetJSON("/dataassetmanager/directoryApi/queryDirectoryTreeByMetadataIdPath", payload)
}

export function queryResourceDirectoryAsTree() {
  return PostJSON("/dataassetmanager/directoryApi/querySourceTypeAsTree");
}

export function queryAssetDirectoryAsTree() {
  return PostJSON("/dataassetmanager/directoryApi/queryDataAssetTypeAsTree");
}

export function listAllTopics(payload) {
  return GetJSON("/dataassetmanager/directoryApi/listAllTopics", payload);
}

export function directoryImport(payload) {
  return PostFile("/dataassetmanager/directoryApi/importCheckRepeatPath", payload);
}

export function previewTreeByCustomElements(payload) {
  return PostJSON("/dataassetmanager/directoryApi/previewAsTreeByCustomElements", payload);
}

export function previewTreeByCustomElementsAndResourceType(payload) {
  return PostJSON("/dataassetmanager/directoryApi/previewAsTreeByCustomElementsAndResourceType", payload); 
}

export function saveTreeByCustomElements(payload) {
  return PostJSON("/dataassetmanager/directoryApi/saveCustomElementTree", payload);
}

export function saveTreeByCustomElementsAndResourceType(payload) {
  return PostJSON("/dataassetmanager/directoryApi/savePersonalCustomElementTreeByResourceType", payload);
}

export function assetImport(payload) {
  return PostFile("/dataassetmanager/dataAssetApi/import", payload);
}

// /draftApi/batchUpdateByImport
export function draftImport(payload) {
  return PostFile("/dataassetmanager/draftApi/batchUpdateByImport", payload);
}

export function getDirectoryById(payload) {
  return GetJSON("/dataassetmanager/directoryApi/getDirectoryById", payload);
}

export function getPersonalCustomDirectoryById(payload) {
  return GetJSON("/dataassetmanager/directoryApi/getPersonalCustomDirectoryById", payload);
}

export function upDownDirectory(payload) {
  return PostJSON("/dataassetmanager/directoryApi/upDownDirectory", payload);
}

export function upDownPersonalCustomDirectory(payload) {
  return PostJSON("/dataassetmanager/directoryApi/upDownPersonalCustomDirectory", payload);
}

export function listDirectoryByName(payload) {
  return GetJSON("/dataassetmanager/directoryApi/listDirectoryByName", payload);
}

export function getDirectoryChild(payload) {
  return GetJSON("/dataassetmanager/directoryApi/getChildByParentId", payload);
}

export function getPersonalCustomDirecotryChild(payload) {
  return GetJSON("/dataassetmanager/directoryApi/getPersonalCustomChildByParentId", payload);
}

export function getMetadataModelTree() {
  return GetJSON("/metadatarepo/rest/model/tree");
}

export function getAttributesByMetadataModel(payload) {
  return GetJSON("/dataassetmanager/eleAndAttrApi/getModelAttributes", payload);
}

export function loadElementWithoutCustom() {
  return GetJSON("/dataassetmanager/eleAndAttrApi/loadElementWithoutCustom");
}

export function saveEleAndAttrRel(payload) {
  return PostJSON("/dataassetmanager/eleAndAttrApi/saveEleAndAttrRel", payload);
}

export function getRelAttrByModel(payload) {
  return PostJSON("/dataassetmanager/eleAndAttrApi/getRelAttrByModel", payload);
}

export function listSourceModels() {
  return GetJSON("/dataassetmanager/eleAndAttrApi/listSourceModels")
}

export function saveEleAndAttrRelWithSourceModel(payload) {
  return PostJSON("/dataassetmanager/eleAndAttrApi/saveEleAndAttrRelWithSourceModel", payload)
}

export function getRelAttrBySourceModel(payload) {
  return GetJSON("/dataassetmanager/eleAndAttrApi/getRelAttrBySourceModel", payload)
}

export function deleteRelAttrBySourceModel(payload) {
  return PostJSON("/dataassetmanager/eleAndAttrApi/delEleAndAttrRelWithSourceModel", payload)
}

export function fillElementValueBeforeCreate(payload) {
  return PostJSON("/dataassetmanager/eleAndAttrApi/fillElementValueBeforeCreate", payload);
}

export function listSupportSourceModels() {
  return GetJSON("/dataassetmanager/eleAndAttrApi/listSupportSourceModels");
}

export function countResourceState(payload) {
  return GetJSON("/dataassetmanager/countApi/countResourceState", payload);
}

export function getResourceRelations(payload) {
  return GetJSON("/dataassetmanager/resourceApi/getResourceRelations", payload);
}

export function updateResourceState(payload) {
  return PostJSON("/dataassetmanager/resourceApi/updateResourceState", payload);
}

export function subs(payload) {
  return Get("/dataassetmanager/subApi/subs", payload);
}

export function startFlow(payload) {
  return Post("/dataassetmanager/flowApi/startDataAssetFlow", payload);
}

export function getSystems(payload) {
  return GetJSON(`/authservice/domains/${payload.env}/systems`);
}

export function getStandardTree(payload) {
  return GetJSON('/standard/rest/standard/maintain/tree/list', payload);
}

export function getStandardList(payload) {
  return PostJSON('/standard/rest/standard/maintain/standard/list', payload);
}

export function standardBatchMetadata(payload) {
  return PostJSON('/standard/indicator/save/batch', payload);
}

export function getMetadataStandardList(payload) {
  return PostJSON('/standard/rest/standard/match/find', payload);
}

export function deleteStandardBatchMetadata(payload) {
  return PostJSON('/standard/indicator/delete', payload);
}

export function exportIndicator(payload) {
  return callFetchRaw('post', '/standard/indicator/exportData', payload)
}

export function importIndicator(payload) {
  return PostFile('/standard/indicator/import', payload);
}

export function importIndicatorLog(payload) {
  return GetJSON('/standard/indicator/importLog', payload);
}

export function getPermission(payload) {
  return GetJSON("/dataassetmanager/permissionApi/getPermissionDetail", payload);
}

export function getTemplates() {
  return GetJSON("/dataassetmanager/elementTemplateApi/listSupportTemplates")
}

export function getMetadataTemplates(payload) {
  return GetJSON("/dataassetmanager/elementTemplateApi/listSupportElementTemplatesByMetadataIdPath", payload)
}

export function saveAsDraft(payload) {
  return PostJSON('/dataassetmanager/draftApi/saveAsDraft', payload);
}

export function createDraftDataAssetByMetadataIds(payload) {
  return PostJSON('/dataassetmanager/draftApi/createDataAssetByMetadataIds', payload);
}

export function listDraftDataAssetsByPage(payload) {
  return GetJSON('/dataassetmanager/draftApi/listDataAssetsByPage', payload);
}

export function checkIsNeedSaveAsDraft(payload) {
  return PostJSON('/dataassetmanager/draftApi/checkIsNeedSaveAsDraft', payload);
}

// /draftApi/listDataAssetsByPage
export function getDraftDataAsset(payload) {
  return GetJSON('/dataassetmanager/draftApi/listDataAssetsByPage', payload);
}

// /draftApi/deleteDrafts
export function deleteDraftDataAsset(payload) {
  return PostJSON('/dataassetmanager/draftApi/deleteDrafts', payload);
}

// //draftApi/auditDrafts
export function auditDraftDataAsset(payload) {
  return PostJSON(`/dataassetmanager/draftApi/auditDrafts?${qs.stringify(payload, { arrayFormat: 'repeat' })}`);
}

// /draftApi/getDraftDetail
export function getDraftDataAssetDetail(payload) {
  return PostJSON('/dataassetmanager/draftApi/getDraftDetail', payload);
}

// /dataAssetApi/checkIsNeedSaveAsDraft
export function checkIsNeedSaveAsDraftDataAsset(payload) {
  return PostJSON('/dataassetmanager/dataAssetApi/checkIsNeedSaveAsDraft', payload);
}

// /draftApi/saveAsDraft
export function saveAsDraftDataAsset(payload) {
  return PostJSON('/dataassetmanager/draftApi/saveAsDraft', payload);
}

// /draftApi/updateDraft
export function updateDraftDataAsset(payload) {
  return PostJSON('/dataassetmanager/draftApi/updateDraft', payload);
}


