import React, { useState, Fragment } from "react";
import { Link } from 'react-router-dom';
import { Layout, Menu, Avatar } from 'antd';
import { connect } from 'react-redux';
import classnames from 'classnames';
import { UserOutlined, LogoutOutlined, MenuFoldOutlined, MenuUnfoldOutlined, HomeOutlined, FileOutlined, AppstoreOutlined } from "@ant-design/icons";

import { ContextPath, Open, showMessage } from '../util';

import { routes, routeMap } from '../routes';

import './index.less';
import { dispatchLatest } from "../model";
import logo from "../assets/logo.png";
import FullSearch from './FullSearch';

const { Header, Sider, Content } = Layout;
const { SubMenu } = Menu;

const _Logout = ({session, isHome, location}) => session ?

    <Menu className={ classnames('logout-menu', isHome?'':'ml-auto') } mode="horizontal" theme="light"
      onClick={null}>
      <SubMenu
        title={
          <Fragment>
            <Avatar icon={<UserOutlined />} />
            <span className="ml-2">{`${session.userDName}/${session.userName}`}</span>
          </Fragment>
        }
        key="User"
      >
        <Menu.Item key="SignOut"
          onClick={e => dispatchLatest({type: 'user.signout',  callback: e => {
            showMessage('success', '退出成功!');
            window.setTimeout(e => Open(`${ContextPath}/login`, { target: '_self' }), 1000);
          }})}> 
          <LogoutOutlined />
          <span>退出登录</span>
        </Menu.Item>
      </SubMenu>
    </Menu> : <span />
const Logout = connect(state => {return { session: state.sessionState }})(_Logout)

function GetMenuIcon({ name = '', isMenuItem = false }) {
  if (name === 'home') {
    return <HomeOutlined />;
  } 
  
  return isMenuItem ?<FileOutlined /> : <AppstoreOutlined />;
}

function GetSubMenu(children, depth = 0) {
  return children.map((route, i) => {
    const key = `${depth}-${i}`; 

    return route.children ?
      <SubMenu key={route.path} className={'layout-menu'}
        title={
          <span>
            { GetMenuIcon({ name: route.icon }) }
            <span>{route.text}</span>
          </span>
        }
      >
        {GetSubMenu(route.children, key)}
      </SubMenu> :
      <Menu.Item key={route.path} className={'layout-menu'}>
        <Link to={route.path} >
        { GetMenuIcon({ name: route.icon, isMenuItem: true }) }
        <span>{route.text}</span>
        </Link>
      </Menu.Item>
  })
}

export const ManageLayout = function ({ content, location }) { 
  const subMenus = GetSubMenu(routes), route = routeMap[location.pathname], openKey = (route && route.parent) ? route.parent.path : '';

  const [collapsed, toggle] = useState(false); 
  return <Layout style={{ height: '100vh' }}>
      <Header className={'bg-primary d-flex manage-header'} >

        {/* <Link to={`${ContextPath}/home`} className="manage-sider-logo">
          <img
            src={logo}
            alt=""
            style={{ width: '150px', marginLeft: '24px' }}
          />
        </Link> */}

        {
          collapsed ? <MenuUnfoldOutlined style={{ marginLeft: '16px', marginRight: '100px' }} onClick={() => toggle(!collapsed)} /> : <MenuFoldOutlined style={{ marginLeft: '16px', marginRight: '185px' }} onClick={() => toggle(!collapsed)} />
        }

        <FullSearch />

        <Logout />
        
      </Header>

      <Layout>
        
        <Sider trigger={null} collapsible collapsed={collapsed} style={{ backgroundColor: '#fff' }}>
          <Menu mode="inline" 
            defaultSelectedKeys={[location.pathname]}
            selectedKeys={[location.pathname]}
            defaultOpenKeys={[openKey]}  >
            {subMenus}
          </Menu>
        </Sider>

        <Content className="m-4" style={{ backgroundColor: '#F0F2F5' }}>
          {content}
        </Content>

      </Layout>

    </Layout>
}

export const HomeLayout = function ({ content, location }) {
  const subMenus = GetSubMenu(routes);
  return <Layout style={{ height: '100vh' }}>

    <Header style={{}} className={'bg-white d-flex home-header'}>
      <div className="mr-3">
        <img 
          src={logo}
          alt=""
          style={{ width: '150px'}} 
        />
      </div>
      <Menu
        mode="horizontal"
        selectedKeys={[location.pathname]}
        style={{ lineHeight: '64px'}}>
        {subMenus}
      </Menu>

      <Logout isHome={true} />
    </Header>

    <Layout style={{ backgroundColor: '#eee' }}> 
      {content} 
    </Layout>

  </Layout>
}