import React from "react";
import { routeMap } from '../routes';

import './PageHeaderWrapper.less';

export default class PageHeaderWrapper extends React.Component {
  constructor() {
    super();
    this.state = { routes: null };
  }
  componentDidMount() {
    const { location } = this.props;
    this.getRoutes(location.pathname);
  }

  componentDidUpdate(preProps, preState) {
    const { location } = this.props;
    if (location && preProps.location !== location) {
      this.getRoutes(location.pathname)
    }
  }

  getRoutes(pathname) {
    const route = routeMap[pathname];//RouteStore.getState();
    const routes = [];

    // console.log(route)
    const getParent = (route) => {
      if (route) {
        if (route.text) {
          routes.unshift(route);
        }
        route.parent && getParent(route.parent);
      }
    }

    getParent(route);
    this.setState({ routes });
  }

  render() {
    const { children, extra } = this.props;
    const { routes } = this.state;

    let curRoute = null;
    if (routes && routes.length > 0) {
      curRoute = routes[routes.length - 1];
    }

    return (
      <div className="page-container">
        <div className="page-container-header">
          <div className="pl-3 page-container-header-title"> 
          {
            curRoute && <span>{curRoute.text}</span>
          }
          </div>
          {
            extra&&(
              <div className="ml-auto pr-3">
              { extra }
              </div>
            )
          }
        </div>
        <div className="mt-3 page-container-content">
        { children }
        </div>
      </div>
    );
  }
}
