import "core-js/stable";
import "regenerator-runtime/runtime";
import React from 'react';
import ReactDOM from 'react-dom';

import { ConfigProvider } from 'antd';
import zh_CN from 'antd/es/locale-provider/zh_CN';
import { Provider } from "react-redux";
import { store } from './model';
import { App } from './App'
import { $hostParams } from "./util";

import './index.less';

function render(props) {
  const { container, ...restProps } = props;
  ReactDOM.render(
    //解决主次应用样式冲突
    //https://qiankun.umijs.org/faq#how-to-guarantee-the-main-app-stylesheet-isolated-with-sub-apps
    <ConfigProvider locale={zh_CN} prefixCls="yy">
      <Provider store={store}><App {...restProps} /></Provider>
    </ConfigProvider>, 
    container ? container.querySelector('#root') : document.querySelector('#root'));
}


function storeTest(props) {
  props.onGlobalStateChange((value, prev) => console.log(`[onGlobalStateChange - ${props.name}]:`, value, prev), true);
    
  props.setGlobalState({
    ignore: props.name,
    user: {
      name: props.name,
    },
  });
}

if (!window.__POWERED_BY_QIANKUN__) {
  render({});
}

export async function bootstrap() {
  console.log('[data-govern] react app bootstraped');
}

export async function mount(props) {
  console.log('[data-govern] props from main framework', props);
  storeTest(props);
  render(props);
}

export async function unmount(props) {
  const { container } = props;
  ReactDOM.unmountComponentAtNode(container ? container.querySelector('#root') : document.querySelector('#root'));
}

export async function update(props) {
  $hostParams.next(props?.data);
}