import React from 'react';
import {
  BrowserRouter as Router,
  Route, Switch
} from 'react-router-dom';

import { $hostParams, ContextPath, generateUUID } from './util';
import Signin from './view/Signin';
import Home from './view/Home';
import Manage from './view/Manage';
import Map from './view/Manage/Map';
import Model from './view/Manage/Model';
import ModelConfig from './view/Manage/ModelConfig';
import AssetManage from './view/Manage/AssetManage';
import AssetResourceBrowse from './view/Manage/AssetResourceBrowse';
import AssetBrowse from './view/Manage/AssetBrowse';
import AssetRecycle from './view/Manage/AssetRecycle';
import DatasourceManage from './view/Manage/DatasourceManage';
import AssetDetailPage from './view/Manage/AssetManage/Component/AssetDetailPage';
import AssetDetail from './view/Manage/AssetManage/Component/AssetDetail';
import ImportAction from './view/Manage/Model/Component/ImportAction';
import EditModel from './view/Manage/Model/Component/EditModel';
import EditTemplate from './view/Manage/ModelConfig/Component/EditTemplate';
import AssetDraft from './view/Manage/AssetDraft';
import AssetTree from './view/Manage/AssetManage/Component/AssetManageTree';
import AssetNewDetail from "./view/Manage/AssetManage/Component/AssetAction"

import { AssetMountReference } from './util/constant';

export const AppContext = React.createContext();

export const appId = generateUUID();

export class App extends React.Component {
  constructor() {
    super();

    this.state = {
      hostParams: null
    };
  }

  componentDidMount() {
    this.setState({ hostParams: this.props?.data });

    this.$$hostParams = $hostParams.subscribe({
      next: (v) => {
        if (v) {
          this.setState({ hostParams: v });
        }
      },
    });

  }

  componentWillUnmount() {
    this.$$hostParams?.unsubscribe();
  }

  render() {

    const { setGlobalState, onGlobalStateChange } = this.props;
    const { hostParams } = this.state;

    let message = '', id = '', terms = [],dirId='',templateType='';
    if (hostParams) {
      message = hostParams.message||'';
      id = hostParams.id||'';
      terms = hostParams.terms||[];
      dirId = hostParams.dirId||'';
      templateType = hostParams.templateType||''
    }

    console.log('dirId',hostParams)

    if (message === 'showDataModelDetail') {
      return (
        <AppContext.Provider value={{
          setGlobalState,
          onGlobalStateChange
        }}>
          <ImportAction
            modelerId={id} 
            action='detail'
            terms={terms}
          />
        </AppContext.Provider>
      );
    }

    if (message === 'showDataModelFlowDetail') {
      return (
        <AppContext.Provider value={{
          setGlobalState,
          onGlobalStateChange
        }}>
          <ImportAction
            modelerId={id} 
            action='flow'
            editable={false}
            terms={terms}
          />
        </AppContext.Provider>
      );
    }
    
    if (message === 'showAssetDetail') {
      return (
        <AppContext.Provider value={{
          env: hostParams?.env,
          user: hostParams?.user,
          setGlobalState,
          onGlobalStateChange
        }}>
          <AssetNewDetail id={id} dirId={dirId} templateType={templateType} action='detail' />
          {/* <AssetDetail
            id={id} 
            terms={terms}
          /> */}
        </AppContext.Provider>
      );
    }

    if (message === 'showAssetTree') {
      return (
        <AppContext.Provider value={{
          env: hostParams?.env,
          user: hostParams?.user,
          setGlobalState,
          onGlobalStateChange
        }}>
          <AssetTree 
            reference={AssetMountReference}
            metadataIds={hostParams.data}
            checkable={true}
            onCheck={(values) => { 
              hostParams?.callback&&hostParams?.callback(values); 
            }}
            {...this.props} 
          />
        </AppContext.Provider> 
      );
    }

    if (message === 'showDatasource') {
      return (
        <AppContext.Provider value={{
          env: hostParams?.env,
          user: hostParams?.user,
          setGlobalState,
          onGlobalStateChange
        }}>
          <DatasourceManage />
        </AppContext.Provider>
      );
    }

    return (
      <AppContext.Provider value={{
        env: hostParams?.env,
        user: hostParams?.user,
        setGlobalState,
        onGlobalStateChange
      }}>
        <Router basename={window.__POWERED_BY_QIANKUN__ ? '/data-govern' : '/'}>
          <Switch>
            <Route path={`${ContextPath}/login`} component={Signin} exact />
            <Route path={`${ContextPath}/home`} component={Home} />
            <Route path={`${ContextPath}/manage`} component={Manage} />
            <Route path={`${ContextPath}/data-model-action`} component={EditModel} exact />   
            <Route path={`${ContextPath}/model-template-action`} component={EditTemplate} exact />    
            <Route path={`${ContextPath}/asset-detail`} component={AssetDetailPage} exact />   

            <Route path={'/center-home/menu/datasource-manage'} component={DatasourceManage} exact />
            <Route path={'/center-home/menu/data-model'} component={Model} exact />
            <Route path={'/center-home/menu/model-config'} component={ModelConfig} exact />
            <Route path={'/center-home/menu/asset-manage'} component={AssetManage} exact />
            <Route path={'/center-home/menu/asset-resource-browse'} component={AssetResourceBrowse} exact />
            <Route path={'/center-home/menu/asset-browse'} component={AssetBrowse} exact />
            <Route path={'/center-home/menu/asset-recycle'} component={AssetRecycle} exact /> 
            <Route path={'/center-home/data-model-action'} component={EditModel} exact />
            <Route path={'/center-home/menu/asset-draft'} component={AssetDraft} exact />
            <Route path={'/center-home/asset-detail'} component={AssetDetailPage} exact />
            <Route path={'/center-home/session/asset-detail'} component={AssetDetailPage} exact />
          </Switch>
        </Router>
      </AppContext.Provider>
    );
  }
}