const CracoLessPlugin = require('craco-less');
const { name } = require('./package');

module.exports = {
  plugins: [
    {
      plugin: CracoLessPlugin,
      options: {
        lessLoaderOptions: {
          lessOptions: {
            modifyVars: {
              '@ant-prefix': 'yy',
              // '@border-color-split': 'hsv(0, 0, 85%)',
              '@border-radius-base': '4px',
              '@primary-color': '#ffbc00',
              '@success-color': '#8FC31F',
              '@warning-color': '#F7AB00',
              '@error-color': '#db0007',
              '@menu-dark-bg': '#00477F',
              '@menu-dark-submenu-bg': '#013D6C',
              '@menu-dark-inline-submenu-bg': '#013D6C',
              '@layout-header-background': '#00477F',
             },
            javascriptEnabled: true,
          },
        },
      },
    },
  ],
  webpack: {
    configure: {
      output: {
        library: `${name}-[name]`,
        libraryTarget: 'umd',
        chunkLoadingGlobal: `webpackJsonp_${name}`,
        globalObject: 'window',
      },
      module: {
        rules: [
          {
            test: /\.m?js/,
            resolve: {
              fullySpecified: false,
            },
          },
        ],
      },
    }
  },
  devServer: {
    headers: {
      'Access-Control-Allow-Origin': '*',
    },
    // historyApiFallback: true,
    // hot: false,
    // watchContentBase: false,
    // liveReload: false,
  },
};