import { loadMicroApp, MicroApp } from 'qiankun'
import React, { useEffect, useRef, useState } from 'react'
import {useSelector} from "react-redux"

const App= (props)=> {

  const containerRef = useRef(null)
  const microApp = useRef()

  const {view, did, sid} = props

  const time = new Date().getTime()

  const location = props.location;


  useEffect(() => {
    if (!!containerRef.current) {
      microApp.current = loadMicroApp(
        { name: 'metadata-analysis', entry: `/metadata-analysis/?time=${time}`, container: containerRef.current, props: { type: 'er' } },
      );
    }

    return () => {
      microApp.current?.unmount();
    }
  }, [])

  useEffect(() => {

    function updateMicroApp() {
      if (microApp.current?.update) {
        microApp.current?.update?.({ view, did, sid });
      } else {
        setTimeout(() => {
          updateMicroApp();
        }, 100)
      }
    }
    
    updateMicroApp();
    
  }, [view, did, sid])

  return (
    <>
      <div ref={containerRef} style={{ width: '100%', height: '100%' }} />
    </>
  );
}

export default App