import React, { useState } from 'react';
import { Tabs } from 'antd';

import WordTemplate from './Component/WordTemplate';
import TemplateCURD from './Component/TemplateCURD';
import RuleCURD from './Component/rule';
import RuleTemplateCURD from './Component/rule-template';
import PartitionCURD from './Component/PartitionCURD';

import './index.less';

const { TabPane } = Tabs;

const ModelConfig = () => {
  const [ tabKey, setTabKey ] = useState('1');

  const onTabChange = (key) => {
    setTabKey(key);
  }

  return (
    <div className='model-config'>
      <Tabs activeKey={tabKey} onChange={onTabChange}>
        <TabPane tab='生成表类型配置' key='1'>
          <TemplateCURD />
        </TabPane>
        <TabPane tab='规范配置' key='2'>
          <RuleCURD />
        </TabPane>
        <TabPane tab='规则库管理' key='3'>
          <RuleTemplateCURD />
        </TabPane>
        <TabPane tab='分区配置' key='4'>
          <PartitionCURD />
        </TabPane>
      </Tabs>
    </div>
  )
}

export default ModelConfig;