import React, { useEffect, useState } from 'react';
import { Table, Button, Tooltip, Modal, Divider } from 'antd';

import { dispatch } from '../../../../model';
import { showMessage } from '../../../../util';
import UpdatePartitionModal from './UpdatePartitionModal';

const PartitionCURD = (props) => {

  const [ partitions, setPartitions ] = useState([]);
  const [ loading, setLoading ] = useState(false);

  const [ actionData, setActionData ] = useState({ action: '', updataPartitionModalVisible: false, item: null });

  const { action, updataPartitionModalVisible, item } = actionData;

  const [modal, contextHolder] = Modal.useModal();

  useEffect(() => {

    getPartitions();

  }, [])

  const columns = [
    {
      title: '序号',
      dataIndex: 'key',
      editable: false,
      render: (text, record, index) => {
        return (index+1).toString();
      },
      width: 60,
    },
    {
      title: '分区名称',
      dataIndex: 'name',
      width: 180,
      ellipsis: true,
      render: (text, _, __) => {
        return (
          <Tooltip title={text||''}>
            <span>{text||''}</span>
          </Tooltip>
        )
      }
    },
    {
      title: '分区中文名称',
      dataIndex: 'cnName',
      width: 180,
      ellipsis: true,
      render: (text, _, __) => {
        return (
          <Tooltip title={text||''}>
            <span>{text||''}</span>
          </Tooltip>
        )
      }
    },
    {
      title: '分区方式',
      dataIndex: 'partitionMethod',
      width: 180,
      ellipsis: true,
      render: (text, _, __) => {
        return (
          <Tooltip title={text||''}>
            <span>{text||''}</span>
          </Tooltip>
        )
      }
    },
    {
      title: '定义',
      dataIndex: 'definition',
      ellipsis: true,
      render: (text, _, __) => {
        return (
          <Tooltip 
            placement='topLeft'
            title={
              <div style={{ maxWidth: 400, maxHeight: 300, overflow: 'auto' }}>
              {text||''}
              </div>
            }
           overlayClassName='tooltip-common'
          >
            <span>{text||''}</span>
          </Tooltip>
        )
      }
    },
    {
      title: '描述',
      dataIndex: 'remark',
      width: 180,
      ellipsis: true,
      render: (text, _, __) => {
        return (
          <Tooltip title={text||''}>
            <span>{text||''}</span>
          </Tooltip>
        )
      }
    },
    {
      title: '操作',
      key: 'action',
      width: 120,
      render: (text,record) => {
        return (  
          <div style={{ display: 'flex', alignItems: 'center'  }}>
            <Button 
              type='link'
              size='small'
              onClick={() => { editItem(record); }}
              style={{ padding: 0 }}
            >
            编辑
            </Button>
            <div style={{ margin: '0 5px' }}>
              <Divider type='vertical' />
            </div>
            <Button
              type='link'
              size='small'
              onClick={() => { deleteItem(record); }}
              style={{ padding: 0 }}
            >
            删除
            </Button>
          </div>
        )
      }
    }
  ];

  const getPartitions = () => {
    setLoading(true);
    dispatch({
      type: 'datamodel.getSupportedPartitionTypes',
      payload: {
        excludeBuiltin: true
      },
      callback: data => {
        setPartitions(data||[]);
        setLoading(false);
      },
      error: () => {
        setLoading(false);
      }
    })
  }

  const editItem = (record) => {
    setActionData({...actionData, ...{action: 'edit', updataPartitionModalVisible: true, item: record }});
  }

  const deleteItem = (record) => {
    modal.confirm({
      title: '提示!',
      content: '您确定要删除该分区吗?',
      onOk: () => {
        dispatch({
          type: 'datamodel.deletePartitionType',
          payload: {
            params: {
              id: record.id
            }
          },
          callback: () => {
            showMessage('success', '模版分区成功');
            getPartitions();
          }
        })
      }
    });
  }

  const onAddClick = () => {
    setActionData({...actionData, ...{action: 'add', updataPartitionModalVisible: true }});
  }

  const onUpdatePartitionModalCancel = (refresh = false) => {
    setActionData({...actionData, updataPartitionModalVisible: false} );

    refresh && getPartitions();
  }

  return (
    <div>
      <div className='d-flex mb-3' style={{ alignItems: 'center' }}>
        <Button 
          onClick={onAddClick} 
        >
        新建
        </Button>
      </div>
      <Table
        loading={loading}
        columns={columns} 
        rowKey={'id'}
        dataSource={partitions||[]}
        pagination={false} 
        sticky
      />
      <UpdatePartitionModal 
        visible={updataPartitionModalVisible}
        action={action}
        item={item}
        onCancel={onUpdatePartitionModalCancel}
      />
    { contextHolder }
    </div>
  );
}

export default PartitionCURD;