import React from 'react'
import { Drawer } from 'antd'

const FC = (props) => {
  const { visible, title, url, onCancel } = props
  return (
    <Drawer visible={visible}
      title={title}
      destroyOnClose
      width='80%'
      bodyStyle={{
        height: '100%',
        overflow: 'hidden',
        padding: 0
      }}
      onClose={onCancel}
    >
      <iframe width='100%' height='100%' src={url} style={{ border: 'none' }} />
    </Drawer>
  )
}

export default FC