import { useEffect, useState, useRef } from 'react';
import { Typography, Tooltip } from 'antd';
import Table from '../../../../util/Component/Table';

const { Text, Paragraph, Title } = Typography;

const VersionCompareProcess = (props) => {

  const { data, direction = 'left' } = props;
  const [ columns, setColumns ] = useState([]);
  const [ tableData, setTableData ] = useState([]);

  const compareTableDataRef = useRef();
  const hiddenDivRef = useRef();

  useEffect(() => {

    const newColumns = [];
    (data?.heads?.processingHead||[]).forEach((item, index) => {
      const newColumn = {
        title: item||'',
        dataIndex: `column${index}`,
        render: (attrValue, record, _index) => {
          let stateClassName = '', height = 0, compareHeight = 0;
          if (attrValue?.state==='ADD' || attrValue?.state==='UPDATE') {
            stateClassName = 'add';
          } else if (attrValue?.state === 'DELETE') {
            stateClassName = 'delete';
          }

          const compareValue = compareTableDataRef.current?.[_index]?.[`column${index}`]?.value;

          console.log('compareValue', compareValue)

          const _span = document.createElement('span');

          _span.innerText = attrValue?.value??'';
          hiddenDivRef.current?.appendChild(_span);
          height = hiddenDivRef.current?.getBoundingClientRect().height
          hiddenDivRef.current?.removeChild(_span);

          _span.innerText = compareValue??'';
          hiddenDivRef.current?.appendChild(_span);
          compareHeight = hiddenDivRef.current?.getBoundingClientRect().height
          hiddenDivRef.current?.removeChild(_span);

          return (
            <div style={{ position: 'relative' }}>
              {
                (height>compareHeight) ? <div className={stateClassName}>{attrValue?.value||''}</div> : <>
                  <div className={stateClassName} style={{ 
                    position: 'absolute', 
                    top: '50%',
                    left: 0,
                    transform: 'translateY(-50%)',
                  }}>
                    {attrValue?.value||''}
                  </div>
                  <div style={{ visibility: 'hidden' }}>{compareValue}</div>
                </>
              }
            </div>
          );
        },
        ellipsis: false,
      };

      newColumns.push(newColumn);
    })

    setColumns(newColumns);

    const newTableData = [], newCompareTableData = [];
    let processingValue = [], compareProcessingValue = [];
    if (direction==='left') {
      processingValue = data?.left?.processingValue||[];
      compareProcessingValue = data?.right?.processingValue||[];
    } else if (direction==='right') {
      processingValue = data?.right?.processingValue||[];
      compareProcessingValue = data?.left?.processingValue||[];
    }

    (processingValue||[]).forEach((attrItem) => {
      let newAttrItem = {};
      (attrItem||[]).forEach((item, index) => {
        newAttrItem[`column${index}`] = item;
      })
      newTableData.push(newAttrItem);
    });

    (compareProcessingValue||[]).forEach((attrItem) => {
      let newAttrItem = {};
      (attrItem||[]).forEach((item, index) => {
        newAttrItem[`column${index}`] = item;
      })
      newCompareTableData.push(newAttrItem);
    });

    compareTableDataRef.current = newCompareTableData;
    setTableData(newTableData);
    
    //eslint-disable-next-line react-hooks/exhaustive-deps
  }, [ data ])

  return (
    <div>
      <div className='my-3'>
        <Typography>
          <Title level={5}>加工步骤</Title>
        </Typography>
      </div>
      <Table
        columns={columns||[]}
        dataSource={tableData}
        pagination={false}
      />
      <div style={{ width: 0, height: 0 }} >
        <div style={{ width: 100 }} ref={hiddenDivRef}></div>
      </div>
    </div>
  );
}

export default VersionCompareProcess;