import React from 'react';
import { Input } from 'antd';

class ImportDDL extends React.Component {

  constructor() {
    super();
    this.state = {
      inputValue: ''
    };
  }

  componentDidUpdate(preProps, preState) {
    const { visible } = this.props;
    if (!visible && visible !== preProps.visible) {
      this.setState({ inputValue: '' });
    }
  }

  onInputChange = (e) => {
    const { onChange } = this.props;
    this.setState({ inputValue: e.target.value }, () => {
      onChange && onChange(e.target.value);
    });
  }


  render() {

    const { inputValue } = this.state;

    const _placeholder = '支持两种方式创建\n方式一: DDL内容复制粘贴\n方式二: 手动输入DDL';

    return (
      <Input.TextArea 
        value={inputValue||''}
        onChange={this.onInputChange} 
        autoSize={{minRows:4,maxRows:20}} 
        placeholder={_placeholder}
      >
      </Input.TextArea>
    )
  }
}

export default ImportDDL;