import React from 'react';
import { Row, Col } from 'antd';
import classnames from 'classnames';

import './SquareItem.less';

import dirImg from "./assets/1.png";
import assetImg from "./assets/3.png";

class SquareItem extends React.Component {

  onItemClick = () => {
    const { item, onClick } = this.props;
    if (onClick && item) {
      if (item.dbType === 'Dir') {
        onClick(item);
      } else {
        
      }
    }
  }

  render() {
    const { item } = this.props;

    const title = (item.dbType==='Dir') ? (item.dirName||'') : (item.cnName||'');
    const content = (item.dbType==='Dir') ? (item.subDirCount + item.tableModelCount) : (item.enName||'');

    const rightClasses = classnames('right', {
      'right-asset': (item.dbType!=='Dir')
    });  

    return (
      <Row className='map-square-item' onClick={this.onItemClick} style={{ cursor: (item.dbType==='Dir')?'pointer':'default' }}>
        <Col span={8} className='left'>
          <div className='flex' style={{ height: '100%', justifyContent: 'center', alignItems: 'center' }}>
            <img src={(item.dbType==='Dir')?dirImg:assetImg}  style={{ width: '38px', height: '38px' }} alt="" />
          </div>
        </Col>
        <Col span={16} className={rightClasses} style={{ backgroundPosition: 'bottom right' }}>
          <div className='flex' style={{ height: '100%', alignItems: 'center' }}>
            <div className='flex-auto textOverflow'>
              <div className='title textOverflow' title={title}>{title}</div>
              <div className='content textOverflow' title={content}>{content}</div>
            </div>
          </div>
        </Col>
      </Row>
    );
  }
}

export default SquareItem;