import React, { useState, useEffect } from 'react';
import { Modal, Table, Typography, Spin, Empty, Button } from 'antd';

import { dispatch } from '../../../../model';

const TaskLogModal = (props) => {
  const { visible, onCancel, id } = props;

  const [ stateDatas, setStateDatas ] = useState([]); 
  const [ taskTracersBindStateId, setTaskTracersBindStateId ] = useState([]);
  const [ expandedRowKeys, setExpandedRowKeys ] = useState([]);

  const columns = [
    {
      title: '序号',
      dataIndex: 'key',
      render: (text, record, index) => {
        return (index+1).toString();
      },
      width:80
    },
    {
      title: '执行状态',
      dataIndex: 'stateDesc',
      ellipsis: true,
    },
    {
      title: '开始时间',
      dataIndex: 'tsDate',
      ellipsis: true,
    },
    {
      title: '结束时间',
      dataIndex: 'etsDate',
      ellipsis: true
    }
  ];

  useEffect(() => {

    if (visible) {
      getTaskStates();
    }
    
    //eslint-disable-next-line react-hooks/exhaustive-deps
  }, [ visible ])

  const getTaskStates = () => {
    dispatch({
      type: 'datasource.getTaskStates',
      payload: {
        harvestingTaskId: id
      },
      callback: data => {
        setStateDatas(data||[]);
      }
    })
  }

  const reset = () => {
    setStateDatas([]);
    setTaskTracersBindStateId([]);
    setExpandedRowKeys([]);
  }

  return (
    <Modal
      className='task-report-modal'
      forceRender
      title={'日志详情'}
      visible={visible}
      width={1000}
      onCancel={() => { 
        reset();
        onCancel && onCancel() 
      }}
      footer = {
        <Button
          key="1" 
          type="primary"
          onClick={() => {
            reset();
            onCancel && onCancel() 
          }}
        >
        取消
        </Button>
      }
    >
      <Table
        className='mt-5'
        columns={columns} 
        rowKey={'id'}
        dataSource={stateDatas||[]}
        pagination={false} 
        sticky
        expandable={{
          expandedRowRender: record => {

            let _tracer = null;
            (taskTracersBindStateId||[]).forEach(item => {
              if (item.key === record.id) {
                _tracer = item.value||[];
              }
            })

            return (
              <Spin spinning={_tracer===null}>
              {
                (_tracer||[]).length === 0 && <Empty image={Empty.PRESENTED_IMAGE_SIMPLE} description="暂无日志" />
              }
              {
                _tracer && _tracer.map((_item, index) => {
                  return (
                    <Typography.Paragraph key={index} >
                    {_item.value||''}
                    </Typography.Paragraph>
                  )
                })
              }
              </Spin>
            );
          },
          expandedRowKeys,
          onExpand: (expanded, record) => {
            let exsit = false;
            (taskTracersBindStateId||[]).forEach(item => {
              if (item.key === record.id) {
                exsit = true;
              }
            })

            const newExpandedKeys = [...expandedRowKeys];
            if (expanded) {
              newExpandedKeys.push(record.id||'');
            } else {
              const index = newExpandedKeys.indexOf(record.id||'');
              newExpandedKeys.splice(index, 1);
            }

            setExpandedRowKeys([...newExpandedKeys]);

            if (expanded && !exsit) {
              setTaskTracersBindStateId([...taskTracersBindStateId, { key: record.id, value: record.executionTraces||[] }]);
            }

          }
        }}
      />
    </Modal>
  );
}

export default TaskLogModal;
