import React, { useContext } from 'react';
import { Card, Typography, Space, Button, Tooltip, Progress } from 'antd';
import { EditOutlined, DeleteOutlined, DatabaseOutlined, FileOutlined, ScheduleOutlined } from '@ant-design/icons';

import { DatasourceContext } from './ContextManager';
import './TaskItem.less';

const TaskItem = (props) => {
  const { data } = props;
  
  const { onStartTask, onLogTask, onEditTask, onDeleteTask, onScheduleShow, tasksProgress } = useContext(DatasourceContext);

  let disableEdit = false, editTip = '修改';

  if (tasksProgress&&tasksProgress[data.id]!==null&&tasksProgress[data.id]!==undefined) {
    disableEdit = true;
    editTip = '正在抽取中,不允许修改任务';
  }

  return (
    <Card className='task-item'>
      <div>
      {
        data && (data.targetConfParameters||[]).map((param, index) => {
          return (
            <Typography.Paragraph className='mt-1' key={index} title={ `${param.cnName||''}: ${param.value||''}` } ellipsis>
            { `${param.cnName||''}: ${param.value||''}` }
            </Typography.Paragraph>
          );
        })
      }
      </div>
      {
        tasksProgress&&tasksProgress[data.id]!==null&&tasksProgress[data.id]!==undefined ?
         <div className='mt-1 flex' style={{ alignItems: 'center', justifyContent: 'space-between' }}>
          <span style={{ marginRight: 5 }}>抽取进度: </span>
          <div style={{ flex: 1 }}>
          <Progress percent={tasksProgress[data.id]} status="active" size='small' />
          </div>
        </div> : <div className='mt-1' style={{ height: 22 }} ></div>
      }
      <div className='d-flex mt-2'>
        <Space style={{ marginLeft: 'auto' }}>
          <Tooltip placement='bottom' title='定时调度'>
            <Button icon={<ScheduleOutlined />} size='small' onClick={() => { onScheduleShow && onScheduleShow(data); }} />
          </Tooltip>
          <Tooltip placement='bottom' title='抽取'>
            <Button icon={<DatabaseOutlined />} size='small' onClick={() => { onStartTask && onStartTask(data); }} />
          </Tooltip>
          <Tooltip placement='bottom' title='日志'>
            <Button icon={<FileOutlined />} size='small' onClick={() => { onLogTask && onLogTask(data); }} />
          </Tooltip>
          <Tooltip placement='bottom' title={editTip}>
            <Button icon={<EditOutlined />} size='small' disabled={disableEdit} onClick={() => { onEditTask && onEditTask(data); }} />
          </Tooltip>
          <Tooltip placement='bottom' title='删除'>
            <Button icon={<DeleteOutlined />} size='small' onClick={() => { onDeleteTask && onDeleteTask(data); }} />
          </Tooltip>
        </Space>
      </div>
    </Card>
  );
}

export default TaskItem;