import React, { useEffect, useState, useContext } from 'react';
import { Row, Col, Typography, Divider, Spin, Empty } from 'antd';

import TaskItem from './TaskItem';
import { dispatch } from '../../../../model';
import { DatasourceContext } from './ContextManager';

import './DatasourceItem.less';

const DatasourceItem = (props) => {
  const { data, expanded, refresh, scope } = props;
  const [ tasks, setTasks ] = useState(null);
  const [ loading, setLoading ] = useState(false);

  const { refreshTasksSuccess } = useContext(DatasourceContext);

  useEffect(() => {
    if (expanded && !tasks) {
      getTasks();
    }

    //eslint-disable-next-line react-hooks/exhaustive-deps
  }, [expanded])

  useEffect(() => {
    if (refresh && expanded) {
      getTasks();
    }
    
    //eslint-disable-next-line react-hooks/exhaustive-deps
  }, [refresh])

  useEffect(() => {
    setTasks(null);
    //eslint-disable-next-line react-hooks/exhaustive-deps
  }, [scope])

  const getTasks = () => {
    setLoading(true);
    dispatch({
      type: 'datasource.getTasksByDatasourceId',
      payload: {
        datasourceId: data.id
      },
      callback: data => {
        setLoading(false);
        setTasks(data);
        refresh && refreshTasksSuccess && refreshTasksSuccess();
      },
      error: () => {
        setLoading(false);
      }
    })
  }

  
  return (
    <div className="datasource-item">
      <Row>
      {
        data && (data.targetParameters||[]).map((param, index) => {
          return param.show ? (
            <Col className='mt-1' key={index} md={8}>
              <Typography.Paragraph title={ `${param.cnName||''}: ${param.value||''}` } ellipsis>
              { `${param.cnName||''}: ${param.value||''}` }
              </Typography.Paragraph>
            </Col>
          ) : null;
        })
      }
      {
        data && data.credential && (data.credential.credentialParameters||[]).map((param, index) => {
          return param.show ? (
            <Col className='mt-1' key={index} md={8}>
              <Typography.Paragraph title={ `${param.cnName||''}: ${param.value||''}` } ellipsis>
              { `${param.cnName||''}: ${param.value||''}` }
              </Typography.Paragraph>
            </Col>
          ) : null;
        })
      }
      </Row>
      {
        expanded && <Divider />
      }
      {
        expanded && <Spin spinning={loading}>
        {
          (tasks||[]).length===0 ? <Empty image={Empty.PRESENTED_IMAGE_SIMPLE} description="暂无任务" /> : <>
            <Divider>任务列表</Divider>
            <Row gutter={10}>
            {
              (tasks||[]).map((task, index) => {
                return (
                  <Col className='mt-3' key={index} md={8}>
                    <TaskItem 
                      key={index} 
                      data={task} 
                    />            
                  </Col>
                );
              })
            }
            </Row>
           </>
        }
        </Spin>
      }
    </div>
  );
}

export default DatasourceItem;