import React, { useEffect, useState } from "react";
import { Spin, Descriptions, Divider } from "antd";

import MetadataInfo from './MetadataInfo';
import { highlightSearchContentByTerms } from '../../../../util';
import { dispatch } from '../../../../model';
import IndexCode from './IndexCode';
// import SelectUser from '../../Model/Component/SelectUsers';

const AssetDetail = (props)=>{
  
  const { id, dirId, terms, reference = '' } = props;
  const [ asset, setAsset ] = useState('');
  const [ types, setTypes ] = useState([]);
  const [ loading, setLoading ] = useState(false);
  const [ users, setUsers ] = useState([]);

  useEffect(() => {

    if ((id||'') !== '') {
      // getUserElements();
      getUsers();
      getAsset([]);
    }
    //eslint-disable-next-line react-hooks/exhaustive-deps
  }, [ id ])

  const getUserElements = () => {
    setLoading(true);
    dispatch({
      type: 'assetmanage.listUserElements',
      callback: data => {
        getAsset(data||[]);
      },
      error: () => {
        setLoading(false);
      }
    })
  }

  const getUsers = () => {
    dispatch({
      type: 'pds.getOwners',
      callback: (data) => {
        setUsers(data);
      }
    })
  }

  const getAsset = (userElements) => {
    setLoading(true);
    dispatch({
      type: 'assetmanage.getDataAssetDetail',
      payload: {
        dataAssetId: id,
        dirId: dirId||'',
        checkPermission: true
      },
      callback: data => {
        setLoading(false);

        // const userElementIds = [];
        // (userElements||[]).forEach(element => {
        //   userElementIds.push(element?.id);
        // })

        // const filterElements = (data?.elements||[]).filter(element => userElementIds.indexOf(element?.id) !== -1);

        // data = { ...data, elements: filterElements }

        setAsset(data);

        const _types = [];
        (data?.elements||[]).forEach(element => {
          if (_types.indexOf(element.type) === -1) {
            _types.push(element.type);
          }
        })

        setTypes(_types);
      },
      error: () => {
        setLoading(false);
      }
    })
  }

  const elementItemComponent = (item) => {
    if (item.name === '资产项') {
      return <MetadataInfo config={false} value={item.value||''} terms={terms} />;
    }

    if (item.name === '指标标准编码') {
      return <IndexCode value={item.value||''} terms={terms} />;
    }

    // if (item.name==='数据关键用户' || item.name==='业务部门负责人' || item.name?.toLowerCase()==='it责任人' || item.name==='创建人' || item.name==='更新人') {
    //   return <SelectUser 
    //     type='detail' 
    //     users={users} 
    //     value={item.value||''} 
    //   />
    // }

    return <span className='text-color'>{highlightSearchContentByTerms(item.value||'', terms)}</span>;
  }

  return(
    <Spin spinning={loading}>
      {
        ((dirId||'')!=='') && <React.Fragment>
          <Descriptions column={2}>
            <Descriptions.Item label='路径'>
            {asset.currentPath||''}
            </Descriptions.Item>
          </Descriptions>
          <Divider style={{ margin: '10px 0' }} />
        </React.Fragment> 
      }
      {
        (types||[]).map((type, index) => {

          const _currentValues = (asset.elements||[]).filter(element => element.type===type);

          return (
            <div key={index}>
              <div className='flex' style={{ alignItems: 'center', padding: (reference==='full-search'&&index===0)?'0 0 15px':'15px 0' }}>
                <div style={{ width: 3, height: 14, backgroundColor: '#0069AC', marginRight: 5 }} />
                <span style={{ fontWeight: 'bold', color: '#464646' }}>{type||''}</span>
              </div>

              <Descriptions column={2}>
              {
                (_currentValues||[]).map((item, index) => {
                  return (
                    <Descriptions.Item label={item.name||''} key={index}>
                    { elementItemComponent(item) }
                    </Descriptions.Item>
                  );
                })
              }
              </Descriptions>

              <Divider style={{ margin: '10px 0' }} />
            </div>
          )
        })
      }
    </Spin>
  )
}

export default AssetDetail;