import * as service from '../service/datasourcemanager';
import { call } from 'redux-saga/effects';

export function *getScopesAndSupportedTargetTypes() {
  const scopes = yield call(service.getScopes);
  const typies = yield call(service.getSupportedTargetTypes);

  return { scopes, typies };
}

export function* getAllSupportedDatasourceTypies() {
  return yield call(service.getAllSupportedDatasourceTypies);
}

export function* getSupportedTargetTypes() {
  return yield call(service.getSupportedTargetTypes);
}

export function* getAllDatasources(payload) {
  return yield call(service.getAllDatasources, payload);
}

export function* saveDatasource(payload) {
  return yield call(service.saveDatasource, payload);
}

export function* validateDatasource(payload) {
  return yield call(service.validateDatasource, payload);
}

export function* getDatasource(payload) {
  return yield call(service.getDatasource, payload);
}

export function* deleteDatasource(payload) {
  return yield call(service.deleteDatasource, payload);
}

export function* getTaskSettingsByDatasource(payload) {
  return yield call(service.getTaskSettingsByDatasource, payload);
}

export function* getTasksByDatasourceId(payload) {
  return yield call(service.getTasksByDatasourceId, payload);
}

export function* saveTask(payload) {
  return yield call(service.saveTask, payload);
}

export function* getTask(payload) {
  return yield call(service.getTask, payload);
}

export function* deleteTask(payload) {
  return yield call(service.deleteTask, payload);
}

export function* startTask(payload) {
  return yield call(service.startTask, payload);
}

export function* getTaskReportSummary(payload) {
  return yield call(service.getTaskReportSummary, payload);
}

export function* getTaskReportDetail(payload) {
  return yield call(service.getTaskReportDetail, payload);
}

export function* getTaskStates(payload) {
  return yield call(service.getTaskStates, payload);
}

export function* getTaskTracerByStateId(payload) {
  return yield call(service.getTaskTracerByStateId, payload);
}

export function* deleteSchedule(payload) {
  return yield call(service.deleteSchedule, payload);
}

export function* getScheduleForm(payload) {
  return yield call(service.getScheduleForm, payload);
}

export function* getScheduleById(payload) {
  return yield call(service.getScheduleById, payload);
}

export function* getScheduleListByTaskId(payload) {
  return yield call(service.getScheduleListByTaskId, payload);
}

export function* saveAndStartSchedule(payload) {
  return yield call(service.saveAndStartSchedule, payload);
}

export function* getAllTaskProgress() {
  return yield call(service.getAllTaskProgress);
}