package com.keymobile.governworkorder.runtime.conf;

import com.keymobile.auth.common.security.CustomizedUserDetailService;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;

import javax.sql.DataSource;

/**
 * SecurityConfig.
 * @author mahx
 * @version 1.0
 * @date 2019/12/27 16:55
 */
@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled = true)
@ComponentScan("com.keymobile.auth.common.security")
public class SecurityConfig {

    @Value("${security.permit}")
    private boolean permit;

    @Bean
    public UserDetailsManager users(DataSource dataSource) {
        return new CustomizedUserDetailService(dataSource);
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new SHA1PasswordEncoder();
    }

    @Bean
    protected SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        if (permit) {
            http.httpBasic().and().authorizeHttpRequests().anyRequest().permitAll();
        } else {
            http.httpBasic().and().authorizeHttpRequests().requestMatchers("/actuator/**", "/rest/openApi/**").permitAll()
                    .and().authorizeHttpRequests().anyRequest().authenticated();
        }

        http.csrf().disable();
        return http.build();
    }

    class SHA1PasswordEncoder implements PasswordEncoder {

        @Override
        public String encode(CharSequence charSequence) {
            return DigestUtils.sha1Hex(charSequence.toString());
        }

        @Override
        public boolean matches(CharSequence charSequence, String s) {
            return DigestUtils.sha1Hex(charSequence.toString()).equals(s);
        }

    }

}
