package com.keymobile.governworkorder.runtime.conf;

import feign.auth.BasicAuthRequestInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * FeignClientConfig.
 * @author mahx
 * @version 1.0
 * @date 2019/12/27 16:55
 */
@Configuration
public class FeignClientConfig {

    @Value("${security.authUser}")
    private String authUser;

    @Value("${security.authPwd}")
    private String authPwd;

    @Bean
    public BasicAuthRequestInterceptor getBasicAuthRequestInterceptor() {
        return new BasicAuthRequestInterceptor(authUser, authPwd);
    }
}