package com.keymobile.governworkorder.core.util;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;


/**
 * 日志操作工具.
 *
 * @author linxu
 * @version 1.0
 * @date 2020/3/25 11:00
 */
public class LogManager {

    private LogManager() {
        //do nothing
    }

    /**
     * trace.
     *
     * @param context context
     * @param e       e
     * @param message message
     */
    public static void logTrace(String context, Throwable e, String message) {
        Logger logger = LoggerFactory.getLogger(context);
        if (logger.isTraceEnabled()) {
            logger.trace(message, e);
        }
    }

    /**
     * trace.
     * @param context context
     * @param message message
     */
    public static void logTrace(String context, String message) {
        logTrace(context, null, message);
    }

    /**
     * debug.
     * @param context context
     * @param message message
     */
    public static void logDebug(String context, String message) {
        Logger logger = LoggerFactory.getLogger(context);
        if (logger.isDebugEnabled()) {
            logger.debug(message);
        }
    }

    /**
     * log.
     * @param context context
     * @param message message
     */
    public static void logInfo(String context, String message) {
        Logger logger = LoggerFactory.getLogger(context);
        if (logger.isInfoEnabled()) {
            logger.info(message);
        }
    }

    /**
     * info.
     * @param context context
     * @param message message
     * @param objects objects
     */
    public static void logInfo(String context, String message, Object... objects) {
        Logger logger = LoggerFactory.getLogger(context);
        String ip = getIp();
        message = StringUtils.replace(message, "{}", "%s");
        message = String.format(message, objects);
        if (logger.isInfoEnabled()) {
            logger.info(message, getUser(), getSessionId(), ip);
        }
    }

    /**
     * warning.
     * @param context context
     * @param e e
     * @param message message
     */
    public static void logWarning(String context, Throwable e, String message) {
        Logger logger = LoggerFactory.getLogger(context);
        if (logger.isWarnEnabled()) {
            logger.warn(message, e);
        }
    }

    /**
     * warning.
     * @param context context
     * @param message message
     */
    public static void logWarning(String context, String message) {
        logWarning(context, null, message);
    }

    /**
     * error.
     * @param context context
     * @param e e
     * @param message message
     */
    public static void logError(String context, Throwable e, String message) {
        Logger logger = LoggerFactory.getLogger(context);
        if (logger.isErrorEnabled()) {
            logger.error(message, e);
        }
    }

    /**
     * error.
     * @param context context
     * @param message message
     */
    public static void logError(String context, String message) {
        Logger logger = LoggerFactory.getLogger(context);
        if (logger.isErrorEnabled()) {
            logger.error(message);
        }
    }

    /**
     * 获取sessionId.
     * @return sessionId
     */
    public static String getSessionId() {
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        if (attrs != null) {
            return attrs.getSessionId();
        }
        return "NO_SESSION";
    }

    /**
     * 获取IP.
     * @return ip
     */
    public static String getIp() {
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        if (attrs != null) {
            HttpServletRequest request = ((ServletRequestAttributes)attrs).getRequest();
            return IpUtil.getIpAddr(request);
        }
        return "";
    }

    /**
     * 获取用户.
     * @return user
     */
    public static String getUser() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            return auth.getName();
        }
        return "NO_USER";
    }

    public static String getUserName() {
        String user = getUser();
        if (StringUtils.contains(user, ":")) {
            user = StringUtils.substringBefore(user, ":");
        }
        return user;
    }

    public static String getDUserName() {
        String user = getUser();
        if (StringUtils.contains(user, ":")) {
            user = StringUtils.substringAfterLast(user, ":");
        }
        return user;
    }

    public static String getDUserName(String username) {
        if (StringUtils.contains(username, ":")) {
            return StringUtils.substringAfterLast(username, ":");
        }
        return username;
    }

    public static String getUserName(String username) {
        if (StringUtils.contains(username, ":")) {
            return StringUtils.substringBefore(username, ":");
        }
        return username;
    }


}
