package com.keymobile.governworkorder.core.service;

import com.keymobile.governworkorder.core.persistence.model.FileData;
import com.mongodb.client.gridfs.model.GridFSFile;
import jakarta.servlet.http.HttpServletResponse;

import org.bson.Document;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;


@Service
public interface FileService {


    public GridFSFile retrieveFile(String fileId);

    public FileData upload(MultipartFile file);

    public void del(String id);

    public void download(String id, HttpServletResponse response);

    List<Document> find(String fileId);

}
