package com.keymobile.governworkorder.core.persistence.model;

import io.swagger.v3.oas.annotations.media.Schema;

import java.util.Objects;

public class FileData {

    @Schema(description = "上传文件后的获取的文件id", required = true)
    private String id;

    @Schema(description = "上传文件后的获取的文件name", required = true)
    private String fileName;

    public FileData() {
        // do nothing
    }

    public FileData(String id, String fileName) {
        this.id = id;
        this.fileName = fileName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FileData obj = (FileData) o;
        return Objects.equals(id, obj.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}
