package com.keymobile.governworkorder.common.type;


import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum OrderMessageTypeEnum {

    MSG_CREATE("create", "工单创建"),
    MSG_UPDATE("update", "工单更新"),
    MSG_DELETE("delete", "工单删除"),
    MSG_FINISH("finish", "工单完成"),
    MSG_INVALIDATE("invalidate", "工单失效");

    public static final String[] ARRAYS = Arrays.stream(values()).map(OrderMessageTypeEnum::getType).toArray(String[]::new);

    public static final Map<String, String> MAP = Arrays.stream(values())
            .collect(Collectors.toMap(OrderMessageTypeEnum::getType, OrderMessageTypeEnum::getName));

    private  String type;

    private  String name;

    OrderMessageTypeEnum() {
    }

    OrderMessageTypeEnum(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getValueByKey(Integer key) {
        String value = MAP.get(key);
        return value == null ? "" : value;
    }

}
