package com.keymobile.governworkorder.common.bo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * @author xiesh
 * @version 1.0.0
 * @date 2025/8/14
 * @desc 流程审批信息
 */
@Data
@Schema(description = "工单信息")
public class WorkOrderProcessVO {

    @Schema(description = "id")
    private String id;

    /**
     * 工单id
     */
    @Schema(description = "工单id")
    private String workOrderId;
    /**
     * 流程环节 发起、处理、审批
     */
    @Schema(description = "流程环节 发起、处理、审批")
    private String stage;
    /**
     * 类型 通过、驳回
     */
    @Schema(description = "类型 通过、驳回")
    private String type;
    /**
     * 处理意见
     */
    @Schema(description = "处理意见")
    private String content;
    /**
     * 处理人账号
     */
    @Schema(description = "处理人账号")
    private String userName;
    /**
     * 处理人展示名
     */
    @Schema(description = "处理人展示名")
    private String userDname;

    /**
     * 下一步处理人
     */
    @Schema(description = "下一步处理人")
    private String nextUserName;
    /**
     * 下一步处理人展示名
     */
    @Schema(description = "下一步处理人展示名")
    private String nextUserDname;
    /**
     * 创建时间
     */
    @Schema(description = "createTime")
    private String createTime;




}
