package com.keymobile.governworkorder.core.persistence.model;

import jakarta.persistence.Id;
import jakarta.persistence.Transient;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

/**
 * @author xiesh
 * @version 1.0.0
 * @date 2025/8/12
 * @desc 工单信息
 */

@Data
@Document(collection = "g_work_order")
public class WorkOrderInfo {
    /**
     * id
     */
    @Id
    private String id;

    /**
     * 工单标题
     */
    private String title;
    /**
     * 工单描述
     */
    private String desc;
    /**
     * 工单级别
     */
    private String level;
    /**
     * 工单状态 待发起、处理中、工单关闭、工单失效
     */
    private String status;
    /**
     * 流程环节 发起、处理、审批、关闭、失效
     */
    private String stage;
    /**
     * 工单创建时间
     */
    private String createTime;
    /**
     * 创建毫秒
     */
    private long  createTimeMill;

    /**
     * 工单类型  资产完善、资产补录、资产转移
     */
    private String type;

    /**
     * 资产类型  数据指标、数据资产、元数据、数据标准
     */
    private String dataType;
    /**
     * 处理人
     */
    private String handleUserName;
    /**
     * 处理人展示名
     */
    private String handleUserDname;
    /**
     * 处理意见
     */
    private String handleContent;
    /**
     * 下一步操作人展示名
     */
    private String nextUserDname;
    /**
     * 下一步操作人账号
     */
    private String nextUserName;
    /**
     * 创建人展示名
     */
    private String createUserDname;
    /**
     * 创建人账号
     */
    private String createUserName;
    /**
     * 文件id
     */
    private String fileId;
    /**
     * 结束时间
     */
    private String endTime;
    /**
     * 结束时间毫秒
     */
    private long endTimeMill;
    /**
     * 期望完成日期
     */
    private String expectedEndTime;

    /**
     * 更新时间
     */
    private String updateTime;


    @Transient
    private List<WorkOrderData> data;

    @Transient
    private List<WorkOrderProcess> processes;
}
