package com.keymobile.governworkorder.core.persistence.model;

import jakarta.persistence.Id;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @author xiesh
 * @version 1.0.0
 * @date 2025/8/12
 * @desc 工单关联资产数据
 */
@Data
@Document(collection = "g_work_order_data")
public class WorkOrderData {

    @Id
    private String id;

    /**
     * 工单id
     */
    private String workOrderId;

    /**
     * 资产id
     */
    private String dataId;

    /**
     * 资产英文名称
     */
    private String name;

    /**
     * 资产中文名称
     */
    private String cnName;

    /**
     * 名称路径
     */
    private String namePath;

    /**
     * 资产编号
     */
    private String code;
    /**
     * 资产描述
     */
    private String desc;
    /**
     * 处理意见
     */
    private String opinion;
    /**
     * 工单类型  资产属性变更、资产下架、资产新增等 待讨论 资产转移
     */
    private String type;

    /**
     * 资产类型  数据指标、数据资产
     */
    private String dataType;
    /**
     * 处理状态 是、否
     */
    private String handleStatus;
    /**
     * 确认状态 是、否
     */
    private String confirmStatus;

    /**
     *  转移工单 转出属性
     */
    private String transferAttribute;

    /**
     *  转移工单 转出属性中文名
     */
    private String transferAttributeCn;

}
