package com.keymobile.governworkorder.core.exception;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;

@JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME, property = "error", visible = true)
class ApiError {

    private HttpStatus status;
    private final Long timestamp;
    private String message;
    private String cnMessage;

    private ApiError() {
        timestamp = System.currentTimeMillis();
    }

    ApiError(HttpStatus status) {
        this();
        this.status = status;
    }

    ApiError(HttpStatus status, Throwable ex) {
        this();
        this.status = status;
        this.message = ex != null ? ex.getMessage() : "";
    }

    ApiError(HttpStatus status, String message, Throwable ex) {
        this();
        this.status = status;
        String errorMsg = ex != null ? ex.getMessage() : "";
        this.message = StringUtils.isBlank(message) ? errorMsg : message;
    }

    ApiError(HttpStatus status, String message, String cnMessage, Throwable ex) {
        this();
        this.status = status;
        String errorMsg = ex != null ? ex.getMessage() : "";
        this.message = StringUtils.isBlank(message) ? errorMsg : message;
        this.cnMessage = cnMessage;


    }

    public HttpStatus getStatus() {
        return status;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public String getMessage() {
        return message;
    }

    public String getCnMessage() {
        return cnMessage;
    }
}
