package com.keymobile.governworkorder.core.api;

import com.keymobile.governworkorder.common.bo.WorkOrderDataVO;
import com.keymobile.governworkorder.common.bo.WorkOrderInfoVO;
import com.keymobile.governworkorder.common.bo.WorkOrderProcessVO;
import com.keymobile.governworkorder.common.bo.WorkOrderStageVO;
import com.keymobile.governworkorder.core.dto.WorkOrdeQueryDto;
import com.keymobile.governworkorder.core.dto.WorkOrderConfirmDataDto;
import com.keymobile.governworkorder.core.remote.user.User;
import com.keymobile.governworkorder.core.service.WorkOrderService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author xiesh
 * @version 1.0.0
 * @date 2025/8/13
 * @desc
 */
@RestController
@Tag(name = "治理工单api")
@RequestMapping("/workorder")
@Slf4j
public class WorkOrderApi {

    @Autowired
    WorkOrderService workOrderService;


    @RequestMapping(value = "/page", method = {RequestMethod.POST})
    @Operation(summary = "分页查询", description = "")
    public Page<WorkOrderInfoVO> page(@RequestBody WorkOrdeQueryDto param) {
        return workOrderService.page(param);

    }

    @RequestMapping(value = "/add", method = {RequestMethod.POST})
    @Operation(summary = "新增工单", description = "")
    public WorkOrderInfoVO add(@RequestBody WorkOrderInfoVO workOrderVo) {
        WorkOrderInfoVO wordOrder = workOrderService.add(workOrderVo);
        return wordOrder;
    }

    @RequestMapping(value = "/startProcess", method = {RequestMethod.POST})
    @Operation(summary = "启动工单", description = "")
    public void startProcess(@RequestParam String workOrderId) {
        workOrderService.startProcess(workOrderId);
    }

    @RequestMapping(value = "/approvalProcess", method = {RequestMethod.POST})
    @Operation(summary = "审批流程", description = "")
    public void approvalProcess(@RequestParam String workOrderId, @RequestBody WorkOrderProcessVO process) {
        workOrderService.approvalProcess(workOrderId, process);
    }

    @RequestMapping(value = "/saveData", method = {RequestMethod.POST})
    @Operation(summary = "保存工单关联资产数据", description = "")
    public List<WorkOrderDataVO> saveData(@RequestParam String workOrderId, @RequestBody List<WorkOrderDataVO> workOrderDataVOList) {
        return workOrderService.saveData(workOrderId, workOrderDataVOList);
    }

    @RequestMapping(value = "/confirmData", method = {RequestMethod.POST})
    @Operation(summary = "确认数据", description = "")
    public void confirmData(@RequestParam String workOrderId,
                            @RequestBody List<WorkOrderConfirmDataDto> confirmDataList) {
        workOrderService.confirmData(workOrderId, confirmDataList);
    }

    @RequestMapping(value = "/delete", method = {RequestMethod.POST})
    @Operation(summary = "删除数据", description = "")
    public void delete(@RequestParam String workOrderId, @RequestParam(required = false, defaultValue = "false") boolean force) {
        workOrderService.delete(workOrderId, force);
    }

    @RequestMapping(value = "/getData", method = {RequestMethod.GET})
    @Operation(summary = "根据工单id获取关联数据", description = "")
    public List<WorkOrderDataVO> getData(@RequestParam String workOrderId,
                                         @RequestParam(required = false) String namePath,
                                         @RequestParam(required = false) String keyword) {
        return workOrderService.getData(workOrderId, namePath, keyword);
    }

    @RequestMapping(value = "/getProcesses", method = {RequestMethod.GET})
    @Operation(summary = "根据工单id获取审批记录", description = "")
    public List<WorkOrderProcessVO> getProcesses(@RequestParam String workOrderId) {
        return workOrderService.getProcesses(workOrderId);
    }

    @RequestMapping(value = "/getById", method = {RequestMethod.GET})
    @Operation(summary = "根据工单id获取详情信息", description = "")
    public WorkOrderInfoVO getById(@RequestParam String workOrderId) {
        return workOrderService.getById(workOrderId);
    }


    @RequestMapping(value = "/checkCreate", method = {RequestMethod.GET})
    @Operation(summary = "校验是否具有创建工单的权限", description = "")
    public boolean checkCreatePermission(@RequestParam(required = false) String userName) {
        return workOrderService.checkCreatePermission(userName);
    }

    @GetMapping(value = "/users/find")
    @Operation(summary = "人员接口", description = "")
    public List<User> findUser(@RequestParam(value = "types", required = false) String[] types,
                               @RequestParam(value = "dataRoleIds", required = false) Long[] dataRoleIds,
                               @RequestParam(value = "match", required = false) String match,
                               @RequestParam(value = "userGroupIds", required = false) Long[] userGroupIds) {
        return workOrderService.findUser(types, dataRoleIds, match, userGroupIds);
    }

    @GetMapping(value = "/stages")
    @Operation(summary = "流程流转", description = "")
    public List<WorkOrderStageVO> stages(@RequestParam String workOrderId) {
        return workOrderService.stages(workOrderId);
    }

    @GetMapping(value = "/timeoutNotice")
    @Operation(summary = "超时通知", description = "")
    public void timeoutNotice() {
        workOrderService.timeoutNotice();
    }

}
