package com.keymobile.governworkorder.runtime;

import com.keymobile.config.security.ApplicationHelper;
import com.ulisesbocchio.jasyptspringboot.environment.StandardEncryptableEnvironment;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication
@EnableScheduling
@EnableFeignClients(basePackages = {"com.keymobile.governworkorder.core.remote"})
@ComponentScan(basePackages = {"com.keymobile.governworkorder",
        "com.keymobile.config.logging",
        "com.keymobile.config.feignclient",
        "com.keymobile.authservice.component"})
@EntityScan(basePackages = {"com.keymobile.governworkorder.core.persistence.model"})
@EnableMongoRepositories(basePackages = {" com.keymobile.governworkorder.core.persistence.repository"})
public class WorkOrderApplication {

    public static void main(String[] args) {
        System.setProperty("es.set.netty.runtime.available.processors", "false");

        new SpringApplicationBuilder()
                .environment(StandardEncryptableEnvironment.builder().encryptor(stringEncryptor()).build())
                .sources(WorkOrderApplication.class).run(args);
    }

    private static StringEncryptor stringEncryptor() {
        return new StringEncryptor() {
            @Override
            public String encrypt(String s) {
                try {
                    return ApplicationHelper.getEncryptor().encrypt(s);
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public String decrypt(String s) {
                try {
                    return ApplicationHelper.getEncryptor().decrypt(s);
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

}
