package com.keymobile.governworkorder.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.io.Closeable;
import java.io.IOException;
import java.util.*;

/**
 * @author mahx
 * @version 1.0
 * @date 2021/11/24 15:08
 */
@Slf4j
public class ObjectUtil {

    private static final ObjectMapper mapper = new ObjectMapper();

    private ObjectUtil() {
        //do nothing
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        return StringUtils.trimToEmpty(object.toString());
    }

    public static String toEmpty(Object object) {
        String result = toString(object);
        return result == null ? "" : result;
    }

    public static String toJson(Object object) {
        if (object == null) {
            return "";
        }

        try {
            return mapper.writeValueAsString(object);
        } catch (JsonProcessingException e) {
            log.error("生成json报错", e);
            return "";
        }
    }

    public static Map<String, Object> getMap(Object value) {
        if (value == null) {
            return new HashMap<>(0);
        }

        if (value instanceof Map) {
            return (Map<String, Object>) value;
        }

        TypeReference<Map<String, Object>> typeReference = new TypeReference<Map<String, Object>>() {
        };
        try {
            if (value instanceof String) {
                return mapper.readValue((String) value, typeReference);
            }
            return mapper.readValue(mapper.writeValueAsString(value), typeReference);
        } catch (IOException e) {
            log.error("解析错误", e);
            return new HashMap<>(0);
        }
    }

    public static List<Map<String, Object>> getMapList(Object value) {
        if (value == null) {
            return new ArrayList<>(0);
        }

        TypeReference<List<Map<String, Object>>> typeReference = new TypeReference<List<Map<String, Object>>>() {
        };
        try {
            if (value instanceof String) {
                return mapper.readValue((String) value, typeReference);
            }
            return mapper.readValue(mapper.writeValueAsString(value), typeReference);
        } catch (IOException e) {
            log.error("解析错误", e);
            return new ArrayList<>();
        }

    }

    public static <T> T getObject(Object value, TypeReference<T> reference) {
        if (value == null) {
            return null;
        }

        try {
            if (value instanceof String) {
                return mapper.readValue((String) value, reference);
            }
            return mapper.readValue(mapper.writeValueAsString(value), reference);
        } catch (IOException e) {
            log.error("解析错误", e);
            return null;
        }
    }


    public static boolean getBooleanValue(Object value) {
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(toString(value));
    }

    public static Long getLong(Object value) {
        if (value == null) {
            return null;
        }
        return Long.valueOf(toString(value));
    }

    public static long getLongValue(Object value) {
        if (value == null) {
            return 0L;
        }
        return Long.parseLong(toString(value));
    }

    public static int getIntValue(Object value) {
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(toString(value));
    }

    public static Double getDouble(Object value) {
        if (value == null) {
            return null;
        }
        return Double.valueOf(toString(value));
    }

    public static Object toStringForCollectionOrMap(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            return removeBracket(value.toString());
        }
        if (value instanceof String) {
            return removeBracket(value.toString());
        }
        if (value instanceof Map) {
            return toJson(value);
        }
        return value;
    }

    private static String removeBracket(String value) {
        if ("[]".equals(value)) {
            return "";
        } else if (StringUtils.startsWith(value, "[") && StringUtils.endsWith(value, "]")) {
            return StringUtils.substring(value, 1, value.length() - 1);
        }
        return value;
    }

    public static String addBracket(String value) {
        if (!(StringUtils.startsWith(value, "[") && StringUtils.endsWith(value, "]"))) {
            value = "[" + value + "]";
        }
        return value;
    }

    public static void close(Closeable obj) {
        if (obj != null) {
            try {
                obj.close();
            } catch (IOException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

}
