package com.keymobile.governworkorder.core.util;

import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * 获取IP工具类
 *
 * @author laigx
 * @version 1.0
 * @date 2020/3/25 14:51
 */
public class IpUtil {

    public static final String UNKNOWN = "unknown";

    private IpUtil() {
        //do nothing
    }

    private static final Logger log = LoggerFactory.getLogger(IpUtil.class);

    /**
     * 获取IP
     *
     * @param request request
     * @return IP
     */
    public static String getIpAddr(HttpServletRequest request) {
        String ipAddress;
        try {
            ipAddress = request.getHeader("x-forwarded-for");
            if (ipAddress == null || ipAddress.length() == 0 || UNKNOWN.equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || UNKNOWN.equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("WL-Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || UNKNOWN.equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getRemoteAddr();
                if ("127.0.0.1".equals(ipAddress)) {
                    ipAddress = getIpAddress(ipAddress);

                }
            }
            if (ipAddress != null && ipAddress.length() > 15 && ipAddress.contains(",")) {
                ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
            }
        } catch (Exception e) {
            ipAddress = "";
        }
        return ipAddress;
    }

    private static String getIpAddress(String ipAddress) {
        try {
            InetAddress inet = InetAddress.getLocalHost();
            ipAddress = inet.getHostAddress();
        } catch (UnknownHostException e) {
            log.error(e.getMessage(), e);
        }
        return ipAddress;
    }
}
