package com.keymobile.governworkorder.core.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

/**
 * @author mahx
 * @version 1.0
 * @date 2022/4/16 15:35
 */
public class DateUtil {

    private DateUtil() {

    }

    public static List<String> getLastMonth(int n) {
        LocalDate localDate = LocalDate.now();
        int year = localDate.getYear();
        int month = localDate.getMonthValue();
        List<String> result = new ArrayList<>();
        for (int i = 0; i < n; i++) {
            int currentMonth = month - i;
            int currentYear = year;
            if (currentMonth <= 0) {
                currentYear = year - 1;
                currentMonth = currentMonth + 12;
            }
            String date = String.format("%d-%02d", currentYear, currentMonth);
            result.add(date);
        }
        return result.stream().sorted().collect(Collectors.toList());
    }

    public static String getDateTime() {
        return LocalDateTime.now(ZoneId.of("+8")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static String getDate() {
        return LocalDate.now(ZoneId.of("+8")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.CHINA));
    }

    public static String getDateByFormat(String format) {
        return LocalDate.now(ZoneId.of("+8")).format(DateTimeFormatter.ofPattern(format, Locale.CHINA));
    }

    public static String getYesterday() {
        LocalDate localDate = LocalDate.now();
        localDate = localDate.plusDays(-1);
        return localDate.toString();
    }
}
