package com.keymobile.governworkorder.core.service;

import com.keymobile.governworkorder.common.bo.WorkOrderDataVO;
import com.keymobile.governworkorder.common.bo.WorkOrderInfoVO;
import com.keymobile.governworkorder.common.bo.WorkOrderProcessVO;
import com.keymobile.governworkorder.common.bo.WorkOrderStageVO;
import com.keymobile.governworkorder.core.dto.WorkOrdeQueryDto;
import com.keymobile.governworkorder.core.dto.WorkOrderConfirmDataDto;
import com.keymobile.governworkorder.core.remote.user.User;
import org.springframework.data.domain.Page;

import java.util.List;

/**
 * @author xiesh
 * @version 1.0.0
 * @date 2025/8/13
 * @desc
 */
public interface WorkOrderService {
    WorkOrderInfoVO add(WorkOrderInfoVO workOrderVo);

    Page<WorkOrderInfoVO> page(WorkOrdeQueryDto param);

    void startProcess(String workOrderId);

    void approvalProcess(String workOrderId, WorkOrderProcessVO process);

    List<WorkOrderDataVO> saveData(String workOrderId, List<WorkOrderDataVO> workOrderDataVOList);

    void confirmData(String workOrderId, List<WorkOrderConfirmDataDto> confirmDataList);

    void delete(String workOrderId, boolean force);

    List<WorkOrderDataVO> getData (String workOrderId);

    List<WorkOrderProcessVO> getProcesses(String workOrderId);

    WorkOrderInfoVO getById(String workOrderId);

    boolean checkCreatePermission(String userName);

    List<User> findUser(String[] types, Long[] dataRoleIds, String match, Long[] userGroupIds);

    List<WorkOrderStageVO> stages(String workOrderId);

    void timeoutNotice();
}
