package com.keymobile.governworkorder.core.remote;

import com.keymobile.governworkorder.core.remote.user.User;
import com.keymobile.governworkorder.core.remote.user.UserGroup;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

@FeignClient(name = "AuthService")
public interface AuthService {

    @GetMapping(value = "/users")
    List<User> getUserList();

    @GetMapping(value = "/userGroups")
    List<UserGroup> getUserGroups();

    @GetMapping(value = "/userGroups/{userGroupId}/users")
    List<User> getUserListByGroupId(@PathVariable("userGroupId") Long userGroupId);

    @GetMapping(value = "/users/find")
    List<User> find(@RequestParam(value = "types", required = false) String[] types,
                    @RequestParam(value = "dataRoleIds", required = false) Long[] dataRoleIds,
                    @RequestParam(value = "match", required = false) String match,
                    @RequestParam(value = "userGroupIds", required = false) Long[] userGroupIds);

    @GetMapping(value = "/users/exactFindByName")
    Map<String, Object> exactFindByName(@RequestParam(value = "name") String name);
}
