package com.keymobile.governworkorder.core.messaging;

import com.keymobile.governworkorder.common.bo.WorkOrderInfoVO;
import com.keymobile.governworkorder.common.bo.WorkOrderMessage;
import com.keymobile.governworkorder.common.type.OrderMessageTypeEnum;
import com.keymobile.governworkorder.core.util.ObjectUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.UUID;

/**
 * @author xiesh
 * @version 1.0.0
 * @date 2025/8/18
 * @desc
 */
@Service
@Slf4j
public class WorkOrderMessageService {

    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private FanoutExchange exchange;

    public void sendMsg(String type, WorkOrderInfoVO vo) {
        CorrelationData correlationId = new CorrelationData(UUID.randomUUID().toString());
        String content = toMessage(type, vo);
        log.info("sendMessage.exchange:{},content:{}", exchange.getName(), content);
        this.rabbitTemplate.convertAndSend(exchange.getName(), null, content, correlationId);

    }

    private String toMessage(String type, WorkOrderInfoVO vo) {
        WorkOrderMessage message = new WorkOrderMessage();
        message.setType(type);
        message.setDateType(vo.getDataType());
        message.setWorkOrderInfo(vo);
        return ObjectUtil.toJson(message);
    }


}
