package com.keymobile.governworkorder.core.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.data.domain.Sort;

/**
 * @author xiesh
 * @version 1.0.0
 * @date 2025/8/14
 * @desc
 */
@Data
@Schema(description = "工单查询条件")
public class WorkOrdeQueryDto {
    @Schema(description = "分页页数")
    private int page = 1;
    @Schema(description = "分页大小")
    private int size = 10;
    @Schema(description = "排序字段")
    private String sort = "createTime";
    @Schema(description = "排序 DESC 降序、ASC 升序")
    private Sort.Direction direction = Sort.Direction.DESC;
    @Schema(description = "工单级别")
    private String level;
    @Schema(description = "流程环节  流程环节 发起、处理、审批、关闭、失效")
    private String stage;
    @Schema(description = "工单状态  待发起、处理中、工单关闭、工单失效")
    private String status;
    @Schema(description = "工单类型  资产完善、资产补录、资产转移")
    private String type;
    @Schema(description = "资产类型  数据指标、数据资产、元数据、数据标准")
    private String dataType;
    @Schema(description = "关键字")
    private String keyword;
    @Schema(description = "创建开始时间")
    private String startTime;
    @Schema(description = "创建结束时间")
    private String endTime;
    /**
     * 待办已办类型： 1待办、2待办
     */
    @Schema(description = "待办已办类型： 1待办、2待办")
    private String doType;

}
