package com.keymobile.governworkorder.core.api;


import com.keymobile.governworkorder.common.bo.FileDataVO;
import com.keymobile.governworkorder.core.persistence.model.FileData;
import com.keymobile.governworkorder.core.service.FileService;
import com.keymobile.governworkorder.core.util.BeanUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@RestController
@Tag(name = "文件管理", description = "文件管理")
@RequestMapping("file")
public class FileApi{

    @Autowired
    private FileService fileService;

    @PostMapping("/upload")
    @Operation(summary = "上传文件", description = "上传文件")
    public FileDataVO upload(@RequestParam("file") MultipartFile multipartFile) {
        FileData upload = fileService.upload(multipartFile);
        return BeanUtil.map(upload, FileDataVO.class);
    }

    @GetMapping("/download")
    @Operation(summary = "下载文件", description = "下载文件")
    public void download(@RequestParam(value = "id") String id, HttpServletResponse response) {
        fileService.download(id, response);
    }

    @DeleteMapping("/del")
    @Operation(summary = "删除文件", description = "根据id删除文件")
    public void del(@RequestParam(value = "id") String id) {
        fileService.del(id);
    }

    @GetMapping("/find")
    @Operation(summary = "查找", description = "查找")
    public List<Document> find(@RequestParam(value = "id" ,required = false) String id) {
        List<Document> docs = fileService.find(id);
        return docs;
    }

}
