package com.keymobile.governworkorder.common.bo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * @author xiesh
 * @version 1.0.0
 * @date 2025/8/12
 * @desc 工单关联资产数据
 */
@Data
@Schema(description = "工单关联资产数据")
public class WorkOrderDataVO {

    /**
     * id
     */
    @Schema(description = "id")
    private String id;
    /**
     * 工单id
     */
    @Schema(description = "工单id")
    private String workOrderId;

    @Schema(description = "关联资产id")
    private String dataId;

    /**
     * 资产英文名称
     */
    @Schema(description = "资产英文名称")
    private String name;

    /**
     * 资产名称
     */
    @Schema(description = "资产中文名称")
    private String cnName;
    /**
     * 资产编号
     */
    @Schema(description = "资产编号")
    private String code;
    /**
     * 资产描述
     */
    @Schema(description = "资产描述")
    private String desc;
    /**
     * 处理意见
     */
    @Schema(description = "处理意见")
    private String opinion;
    /**
     * 工单类型  资产属性变更、资产下架、资产新增等 待讨论 资产转移
     */
    @Schema(description = "工单类型 资产属性变更、资产下架、资产新增等 待讨论 资产转移")
    private String type;

    /**
     * 资产类型  数据指标、数据资产、元数据、标准
     */
    @Schema(description = "资产类型  数据指标、数据资产、元数据、标准")
    private String dataType;
    /**
     * 处理状态 是、否
     */
    @Schema(description = "处理状态 是、否")
    private String handleStatus;
    /**
     * 确认状态 是、否
     */
    @Schema(description = "确认状态 是、否")
    private String confirmStatus;

    @Schema(description = "创建时间")
    private String createTime;
    @Schema(description = "更新时间")
    private String updateTime;

    @Schema(description = "转移工单 转出属性")
    private String transferAttribute;

    @Schema(description = "转移工单 转出属性中文名")
    private String transferAttributeCn;


}
